/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss.krb5;

import ghostfucker.utils.sun.security.jgss.GSSHeader;
import ghostfucker.utils.sun.security.jgss.krb5.CipherHelper;
import ghostfucker.utils.sun.security.jgss.krb5.Krb5Context;
import ghostfucker.utils.sun.security.jgss.krb5.MessageToken_v2;
import ghostfucker.utils.sun.security.krb5.Confounder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

class WrapToken_v2
extends MessageToken_v2 {
    static final int CONFOUNDER_SIZE = 16;
    private boolean readTokenFromInputStream = true;
    private InputStream is = null;
    private byte[] tokenBytes = null;
    private int tokenOffset = 0;
    private int tokenLen = 0;
    private byte[] dataBytes = null;
    private int dataOffset = 0;
    private int dataLen = 0;
    private int dataSize = 0;
    byte[] confounder = null;
    private boolean privacy = false;
    private boolean initiator = true;

    public WrapToken_v2(Krb5Context krb5Context, byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        super(1284, krb5Context, byArray, n, n2, messageProp);
        this.readTokenFromInputStream = false;
        byte[] byArray2 = new byte[n2];
        if (this.rotate_left(byArray, n, byArray2, n2)) {
            this.tokenBytes = byArray2;
            this.tokenOffset = 0;
        } else {
            this.tokenBytes = byArray;
            this.tokenOffset = n;
        }
        this.tokenLen = n2;
        this.privacy = messageProp.getPrivacy();
        this.dataSize = n2 - 16;
        this.initiator = krb5Context.isInitiator();
    }

    public WrapToken_v2(Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        super(1284, krb5Context, inputStream, messageProp);
        this.is = inputStream;
        this.privacy = messageProp.getPrivacy();
        try {
            this.tokenLen = inputStream.available();
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, WrapToken_v2.getTokenName(this.getTokenId()) + ": " + iOException.getMessage());
        }
        this.dataSize = this.tokenLen - 16;
        this.initiator = krb5Context.isInitiator();
    }

    public byte[] getData() throws GSSException {
        byte[] byArray = new byte[this.dataSize];
        int n = this.getData(byArray, 0);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public int getData(byte[] byArray, int n) throws GSSException {
        if (this.readTokenFromInputStream) {
            this.getDataFromStream(byArray, n);
        } else {
            this.getDataFromBuffer(byArray, n);
        }
        int n2 = 0;
        n2 = this.privacy ? this.dataSize - this.confounder.length - 16 - this.cipherHelper.getChecksumLength() : this.dataSize - this.cipherHelper.getChecksumLength();
        return n2;
    }

    private void getDataFromBuffer(byte[] byArray, int n) throws GSSException {
        int n2 = this.tokenOffset + 16;
        int n3 = 0;
        if (n2 + this.dataSize > this.tokenOffset + this.tokenLen) {
            throw new GSSException(10, -1, "Insufficient data in " + WrapToken_v2.getTokenName(this.getTokenId()));
        }
        this.confounder = new byte[16];
        if (this.privacy) {
            this.cipherHelper.decryptData(this, this.tokenBytes, n2, this.dataSize, byArray, n, this.getKeyUsage());
            n3 = this.dataSize - 16 - 16 - this.cipherHelper.getChecksumLength();
        } else {
            WrapToken_v2.debug("\t\tNo encryption was performed by peer.\n");
            n3 = this.dataSize - this.cipherHelper.getChecksumLength();
            System.arraycopy(this.tokenBytes, n2, byArray, n, n3);
            if (!this.verifySign(byArray, n, n3)) {
                throw new GSSException(6, -1, "Corrupt checksum in Wrap token");
            }
        }
    }

    private void getDataFromStream(byte[] byArray, int n) throws GSSException {
        int n2 = 0;
        this.confounder = new byte[16];
        try {
            if (this.privacy) {
                this.cipherHelper.decryptData(this, this.is, this.dataSize, byArray, n, this.getKeyUsage());
                n2 = this.dataSize - 16 - 16 - this.cipherHelper.getChecksumLength();
            } else {
                WrapToken_v2.debug("\t\tNo encryption was performed by peer.\n");
                WrapToken_v2.readFully(this.is, this.confounder);
                n2 = this.dataSize - this.cipherHelper.getChecksumLength();
                WrapToken_v2.readFully(this.is, byArray, n, n2);
                if (!this.verifySign(byArray, n, n2)) {
                    throw new GSSException(6, -1, "Corrupt checksum in Wrap token");
                }
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, WrapToken_v2.getTokenName(this.getTokenId()) + ": " + iOException.getMessage());
        }
    }

    public WrapToken_v2(Krb5Context krb5Context, MessageProp messageProp, byte[] byArray, int n, int n2) throws GSSException {
        super(1284, krb5Context);
        this.confounder = Confounder.bytes(16);
        this.dataSize = this.confounder.length + n2 + 16 + this.cipherHelper.getChecksumLength();
        this.dataBytes = byArray;
        this.dataOffset = n;
        this.dataLen = n2;
        this.initiator = krb5Context.isInitiator();
        this.genSignAndSeqNumber(messageProp, byArray, n, n2);
        if (!krb5Context.getConfState()) {
            messageProp.setPrivacy(false);
        }
        this.privacy = messageProp.getPrivacy();
    }

    public void encode(OutputStream outputStream) throws IOException, GSSException {
        super.encode(outputStream);
        if (!this.privacy) {
            byte[] byArray = this.getChecksum(this.dataBytes, this.dataOffset, this.dataLen);
            outputStream.write(this.dataBytes, this.dataOffset, this.dataLen);
            outputStream.write(byArray);
        } else {
            this.cipherHelper.encryptData(this, this.confounder, this.getTokenHeader(), this.dataBytes, this.dataOffset, this.dataLen, this.getKeyUsage(), outputStream);
        }
    }

    public byte[] encode() throws IOException, GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.dataSize + 50);
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public int encode(byte[] byArray, int n) throws IOException, GSSException {
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.encode(byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        n += byArray2.length;
        if (!this.privacy) {
            byte[] byArray3 = this.getChecksum(this.dataBytes, this.dataOffset, this.dataLen);
            System.arraycopy(this.dataBytes, this.dataOffset, byArray, n, this.dataLen);
            System.arraycopy(byArray3, 0, byArray, n += this.dataLen, this.cipherHelper.getChecksumLength());
            n2 = byArray2.length + this.dataLen + this.cipherHelper.getChecksumLength();
        } else {
            int n3 = this.cipherHelper.encryptData(this, this.confounder, this.getTokenHeader(), this.dataBytes, this.dataOffset, this.dataLen, byArray, n, this.getKeyUsage());
            n2 = byArray2.length + n3;
        }
        return n2;
    }

    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize() + this.dataSize;
    }

    static int getSizeLimit(int n, boolean bl, int n2, CipherHelper cipherHelper) throws GSSException {
        return GSSHeader.getMaxMechTokenSize(OID, n2) - (WrapToken_v2.getTokenSize(cipherHelper) + 16) - 8;
    }
}

