/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss.spnego;

import ghostfucker.utils.sun.security.jgss.GSSUtil;
import ghostfucker.utils.sun.security.jgss.spnego.SpNegoToken;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.util.ObjectIdentifier;
import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class NegTokenTarg
extends SpNegoToken {
    private int negResult = 0;
    private Oid supportedMech = null;
    private byte[] responseToken = null;
    private byte[] mechListMIC = null;

    NegTokenTarg(int n, Oid oid, byte[] byArray, byte[] byArray2) {
        super(1);
        this.negResult = n;
        this.supportedMech = oid;
        this.responseToken = byArray;
        this.mechListMIC = byArray2;
    }

    public NegTokenTarg(byte[] byArray) throws GSSException {
        super(1);
        this.parseToken(byArray);
    }

    final byte[] encode() throws GSSException {
        try {
            DerOutputStream derOutputStream;
            DerOutputStream derOutputStream2 = new DerOutputStream();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putEnumerated(this.negResult);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            if (this.supportedMech != null) {
                derOutputStream = new DerOutputStream();
                byte[] byArray = this.supportedMech.getDER();
                derOutputStream.write(byArray);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
            if (this.responseToken != null) {
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.responseToken);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream);
            }
            if (this.mechListMIC != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: sending MechListMIC");
                }
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.mechListMIC);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
            } else if (GSSUtil.useMSInterop() && this.responseToken != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: sending additional token for MS Interop");
                }
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.responseToken);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            return derOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + iOException.getMessage());
        }
    }

    private void parseToken(byte[] byArray) throws GSSException {
        try {
            DerValue derValue;
            DerValue derValue2 = new DerValue(byArray);
            if (!derValue2.isContextSpecific((byte)1)) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the right token type");
            }
            DerValue derValue3 = derValue2.data.getDerValue();
            if (derValue3.tag != 48) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the Sequence tag");
            }
            if (derValue3.data.available() > 0) {
                derValue = derValue3.data.getDerValue();
                if (!derValue.isContextSpecific((byte)0)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for negResult");
                }
                this.negResult = derValue.data.getEnumerated();
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: negotiated result = " + NegTokenTarg.getNegoResultString(this.negResult));
                }
            }
            if (derValue3.data.available() > 0) {
                derValue = derValue3.data.getDerValue();
                if (!derValue.isContextSpecific((byte)1)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for supportedMech");
                }
                ObjectIdentifier objectIdentifier = derValue.data.getOID();
                this.supportedMech = new Oid(objectIdentifier.toString());
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: supported mechanism = " + this.supportedMech);
                }
            }
            if (derValue3.data.available() > 0) {
                derValue = derValue3.data.getDerValue();
                if (!derValue.isContextSpecific((byte)2)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for response token");
                }
                this.responseToken = derValue.data.getOctetString();
            }
            if (!GSSUtil.useMSInterop() && derValue3.data.available() > 0) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: receiving MechListMIC");
                }
                if (!(derValue = derValue3.data.getDerValue()).isContextSpecific((byte)3)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for mechListMIC");
                }
                this.mechListMIC = derValue.data.getOctetString();
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: MechListMIC Token = " + NegTokenTarg.getHexBytes(this.mechListMIC));
                }
            } else if (DEBUG) {
                System.out.println("SpNegoToken NegTokenTarg : no MIC token included");
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + iOException.getMessage());
        }
    }

    int getNegotiatedResult() {
        return this.negResult;
    }

    public Oid getSupportedMech() {
        return this.supportedMech;
    }

    byte[] getResponseToken() {
        return this.responseToken;
    }

    byte[] getMechListMIC() {
        return this.mechListMIC;
    }
}

