/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss.spnego;

import ghostfucker.utils.sun.security.jgss.GSSToken;
import ghostfucker.utils.sun.security.jgss.spnego.SpNegoContext;
import ghostfucker.utils.sun.security.jgss.spnego.SpNegoMechFactory;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.util.ObjectIdentifier;
import java.io.IOException;
import org.ietf.jgss.GSSException;

abstract class SpNegoToken
extends GSSToken {
    static final int NEG_TOKEN_INIT_ID = 0;
    static final int NEG_TOKEN_TARG_ID = 1;
    private int tokenType;
    static final boolean DEBUG = SpNegoContext.DEBUG;
    public static ObjectIdentifier OID;

    protected SpNegoToken(int n) {
        this.tokenType = n;
    }

    abstract byte[] encode() throws GSSException;

    byte[] getEncoded() throws IOException, GSSException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.write(this.encode());
        switch (this.tokenType) {
            case 0: {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
                return derOutputStream2.toByteArray();
            }
            case 1: {
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
                return derOutputStream3.toByteArray();
            }
        }
        return derOutputStream.toByteArray();
    }

    final int getType() {
        return this.tokenType;
    }

    static String getTokenName(int n) {
        switch (n) {
            case 0: {
                return "SPNEGO NegTokenInit";
            }
            case 1: {
                return "SPNEGO NegTokenTarg";
            }
        }
        return "SPNEGO Mechanism Token";
    }

    static NegoResult getNegoResultType(int n) {
        switch (n) {
            case 0: {
                return NegoResult.ACCEPT_COMPLETE;
            }
            case 1: {
                return NegoResult.ACCEPT_INCOMPLETE;
            }
            case 2: {
                return NegoResult.REJECT;
            }
        }
        return NegoResult.ACCEPT_COMPLETE;
    }

    static String getNegoResultString(int n) {
        switch (n) {
            case 0: {
                return "Accept Complete";
            }
            case 1: {
                return "Accept InComplete";
            }
            case 2: {
                return "Reject";
            }
        }
        return "Unknown Negotiated Result: " + n;
    }

    static {
        try {
            OID = new ObjectIdentifier(SpNegoMechFactory.GSS_SPNEGO_MECH_OID.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NegoResult {
        ACCEPT_COMPLETE,
        ACCEPT_INCOMPLETE,
        REJECT;

    }
}

