/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss.wrapper;

import ghostfucker.utils.sun.security.action.PutAllAction;
import ghostfucker.utils.sun.security.jgss.wrapper.GSSLibStub;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.HashMap;
import org.ietf.jgss.Oid;

public final class SunNativeProvider
extends Provider {
    private static final long serialVersionUID = -238911724858694204L;
    private static final String NAME = "SunNativeGSS";
    private static final String INFO = "Sun Native GSS provider";
    private static final String MF_CLASS = "ghostfucker.utils.sun.security.jgss.wrapper.NativeGSSFactory";
    private static final String LIB_PROP = "ghostfucker.utils.sun.security.jgss.lib";
    private static final String DEBUG_PROP = "ghostfucker.utils.sun.security.nativegss.debug";
    private static HashMap MECH_MAP;
    static final Provider INSTANCE;
    static boolean DEBUG;

    static void debug(String string) {
        if (DEBUG) {
            if (string == null) {
                throw new NullPointerException();
            }
            System.out.println("SunNativeGSS: " + string);
        }
    }

    public SunNativeProvider() {
        super(NAME, 1.0, INFO);
        if (MECH_MAP != null) {
            AccessController.doPrivileged(new PutAllAction(this, MECH_MAP));
        }
    }

    static {
        INSTANCE = new SunNativeProvider();
        MECH_MAP = AccessController.doPrivileged(new PrivilegedAction<HashMap>(){

            @Override
            public HashMap run() {
                Oid[] oidArray;
                DEBUG = Boolean.parseBoolean(System.getProperty(SunNativeProvider.DEBUG_PROP));
                try {
                    System.loadLibrary("j2gss");
                }
                catch (Error error) {
                    SunNativeProvider.debug("No j2gss library found!");
                    if (DEBUG) {
                        error.printStackTrace();
                    }
                    return null;
                }
                String string = System.getProperty(SunNativeProvider.LIB_PROP);
                if (string == null || string.trim().equals("")) {
                    oidArray = System.getProperty("os.name");
                    if (oidArray.startsWith("SunOS")) {
                        string = "libgss.so";
                    } else if (oidArray.startsWith("Linux")) {
                        string = "libgssapi.so";
                    }
                }
                if (GSSLibStub.init(string)) {
                    SunNativeProvider.debug("Loaded GSS library: " + string);
                    oidArray = GSSLibStub.indicateMechs();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 0; i < oidArray.length; ++i) {
                        SunNativeProvider.debug("Native MF for " + oidArray[i]);
                        hashMap.put("GssApiMechanism." + oidArray[i], SunNativeProvider.MF_CLASS);
                    }
                    return hashMap;
                }
                return null;
            }
        });
    }
}

