/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.Credentials;
import ghostfucker.utils.sun.security.krb5.EncryptedData;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbApReq;
import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.internal.APRep;
import ghostfucker.utils.sun.security.krb5.internal.EncAPRepPart;
import ghostfucker.utils.sun.security.krb5.internal.KRBError;
import ghostfucker.utils.sun.security.krb5.internal.KdcErrException;
import ghostfucker.utils.sun.security.krb5.internal.KerberosTime;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.krb5.internal.LocalSeqNumber;
import ghostfucker.utils.sun.security.krb5.internal.SeqNumber;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;

public class KrbApRep {
    private byte[] obuf;
    private byte[] ibuf;
    private EncAPRepPart encPart;
    private APRep apRepMessg;

    public KrbApRep(KrbApReq krbApReq, boolean bl, boolean bl2) throws KrbException, IOException {
        EncryptionKey encryptionKey = bl2 ? new EncryptionKey(krbApReq.getCreds().getSessionKey()) : null;
        LocalSeqNumber localSeqNumber = new LocalSeqNumber();
        this.init(krbApReq, encryptionKey, localSeqNumber);
    }

    public KrbApRep(byte[] byArray, Credentials credentials, KrbApReq krbApReq) throws KrbException, IOException {
        this(byArray, credentials);
        this.authenticate(krbApReq);
    }

    private void init(KrbApReq krbApReq, EncryptionKey encryptionKey, SeqNumber seqNumber) throws KrbException, IOException {
        this.createMessage(krbApReq.getCreds().key, krbApReq.getCtime(), krbApReq.cusec(), encryptionKey, seqNumber);
        this.obuf = this.apRepMessg.asn1Encode();
    }

    private KrbApRep(byte[] byArray, Credentials credentials) throws KrbException, IOException {
        this(new DerValue(byArray), credentials);
    }

    private KrbApRep(DerValue derValue, Credentials credentials) throws KrbException, IOException {
        APRep aPRep = null;
        try {
            aPRep = new APRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            aPRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            KrbException krbException = new KrbException(kRBError.getErrorCode(), string2);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
        byte[] byArray = aPRep.encPart.decrypt(credentials.key, 12);
        byte[] byArray2 = aPRep.encPart.reset(byArray, true);
        derValue = new DerValue(byArray2);
        this.encPart = new EncAPRepPart(derValue);
    }

    private void authenticate(KrbApReq krbApReq) throws KrbException, IOException {
        if (this.encPart.ctime.getSeconds() != krbApReq.getCtime().getSeconds() || this.encPart.cusec != krbApReq.getCtime().getMicroSeconds()) {
            throw new KrbApErrException(46);
        }
    }

    public EncryptionKey getSubKey() {
        return this.encPart.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.encPart.getSeqNumber();
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    private void createMessage(EncryptionKey encryptionKey, KerberosTime kerberosTime, int n, EncryptionKey encryptionKey2, SeqNumber seqNumber) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n2 = null;
        if (seqNumber != null) {
            n2 = new Integer(seqNumber.current());
        }
        this.encPart = new EncAPRepPart(kerberosTime, n, encryptionKey2, n2);
        byte[] byArray = this.encPart.asn1Encode();
        EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, 12);
        this.apRepMessg = new APRep(encryptedData);
    }
}

