/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.Checksum;
import ghostfucker.utils.sun.security.krb5.Config;
import ghostfucker.utils.sun.security.krb5.Credentials;
import ghostfucker.utils.sun.security.krb5.EncryptedData;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.PrincipalName;
import ghostfucker.utils.sun.security.krb5.Realm;
import ghostfucker.utils.sun.security.krb5.internal.APOptions;
import ghostfucker.utils.sun.security.krb5.internal.APReq;
import ghostfucker.utils.sun.security.krb5.internal.Authenticator;
import ghostfucker.utils.sun.security.krb5.internal.AuthorizationData;
import ghostfucker.utils.sun.security.krb5.internal.EncTicketPart;
import ghostfucker.utils.sun.security.krb5.internal.HostAddress;
import ghostfucker.utils.sun.security.krb5.internal.KRBError;
import ghostfucker.utils.sun.security.krb5.internal.KdcErrException;
import ghostfucker.utils.sun.security.krb5.internal.KerberosTime;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.krb5.internal.LocalSeqNumber;
import ghostfucker.utils.sun.security.krb5.internal.SeqNumber;
import ghostfucker.utils.sun.security.krb5.internal.Ticket;
import ghostfucker.utils.sun.security.krb5.internal.crypto.EType;
import ghostfucker.utils.sun.security.krb5.internal.rcache.AuthTime;
import ghostfucker.utils.sun.security.krb5.internal.rcache.CacheTable;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.net.InetAddress;

public class KrbApReq {
    private byte[] obuf;
    private KerberosTime ctime;
    private int cusec;
    private Authenticator authenticator;
    private Credentials creds;
    private APReq apReqMessg;
    private static CacheTable table = new CacheTable();
    private static boolean DEBUG = Krb5.DEBUG;
    private boolean KDC_EMPTY_ADDRESSES_ALLOWED = true;

    public KrbApReq(Credentials credentials, boolean bl, boolean bl2, boolean bl3, Checksum checksum) throws Asn1Exception, KrbCryptoException, KrbException, IOException {
        APOptions aPOptions;
        APOptions aPOptions2 = aPOptions = bl ? new APOptions(2) : new APOptions();
        if (DEBUG) {
            System.out.println(">>> KrbApReq: APOptions are " + aPOptions);
        }
        EncryptionKey encryptionKey = bl2 ? new EncryptionKey(credentials.getSessionKey()) : null;
        LocalSeqNumber localSeqNumber = new LocalSeqNumber();
        this.init(aPOptions, credentials, checksum, encryptionKey, localSeqNumber, null, 11);
    }

    public KrbApReq(byte[] byArray, EncryptionKey[] encryptionKeyArray, InetAddress inetAddress) throws KrbException, IOException {
        this.obuf = byArray;
        if (this.apReqMessg == null) {
            this.decode();
        }
        this.authenticate(encryptionKeyArray, inetAddress);
    }

    KrbApReq(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.init(aPOptions, ticket, encryptionKey, realm, principalName, checksum, kerberosTime, encryptionKey2, seqNumber, authorizationData, 7);
    }

    private void init(APOptions aPOptions, Credentials credentials, Checksum checksum, EncryptionKey encryptionKey, SeqNumber seqNumber, AuthorizationData authorizationData, int n) throws KrbException, IOException {
        this.ctime = new KerberosTime(true);
        this.init(aPOptions, credentials.ticket, credentials.key, credentials.client.getRealm(), credentials.client, checksum, this.ctime, encryptionKey, seqNumber, authorizationData, n);
    }

    private void init(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData, int n) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.createMessage(aPOptions, ticket, encryptionKey, realm, principalName, checksum, kerberosTime, encryptionKey2, seqNumber, authorizationData, n);
        this.obuf = this.apReqMessg.asn1Encode();
    }

    void decode() throws KrbException, IOException {
        DerValue derValue = new DerValue(this.obuf);
        this.decode(derValue);
    }

    void decode(DerValue derValue) throws KrbException, IOException {
        this.apReqMessg = null;
        try {
            this.apReqMessg = new APReq(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            this.apReqMessg = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            KrbException krbException = new KrbException(kRBError.getErrorCode(), string2);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
    }

    private void authenticate(EncryptionKey[] encryptionKeyArray, InetAddress inetAddress) throws KrbException, IOException {
        int n = this.apReqMessg.ticket.encPart.getEType();
        EncryptionKey encryptionKey = EncryptionKey.findKey(n, encryptionKeyArray);
        if (encryptionKey == null) {
            throw new KrbException(400, "Cannot find key of appropriate type to decrypt AP REP - " + EType.toString(n));
        }
        byte[] byArray = this.apReqMessg.ticket.encPart.decrypt(encryptionKey, 2);
        byte[] byArray2 = this.apReqMessg.ticket.encPart.reset(byArray, true);
        EncTicketPart encTicketPart = new EncTicketPart(byArray2);
        KrbApReq.checkPermittedEType(encTicketPart.key.getEType());
        byte[] byArray3 = this.apReqMessg.authenticator.decrypt(encTicketPart.key, 11);
        byte[] byArray4 = this.apReqMessg.authenticator.reset(byArray3, true);
        this.authenticator = new Authenticator(byArray4);
        this.ctime = this.authenticator.ctime;
        this.cusec = this.authenticator.cusec;
        this.authenticator.ctime.setMicroSeconds(this.authenticator.cusec);
        this.authenticator.cname.setRealm(this.authenticator.crealm);
        this.apReqMessg.ticket.sname.setRealm(this.apReqMessg.ticket.realm);
        encTicketPart.cname.setRealm(encTicketPart.crealm);
        Config.getInstance().resetDefaultRealm(this.apReqMessg.ticket.realm.toString());
        if (!this.authenticator.cname.equals(encTicketPart.cname)) {
            throw new KrbApErrException(36);
        }
        KerberosTime kerberosTime = new KerberosTime(true);
        if (!this.authenticator.ctime.inClockSkew(kerberosTime)) {
            throw new KrbApErrException(37);
        }
        AuthTime authTime = new AuthTime(this.authenticator.ctime.getTime(), this.authenticator.cusec);
        String string = this.authenticator.cname.toString();
        if (table.get(authTime, this.authenticator.cname.toString()) != null) {
            throw new KrbApErrException(34);
        }
        table.put(string, authTime, kerberosTime.getTime());
        if (Config.getInstance().useAddresses()) {
            this.KDC_EMPTY_ADDRESSES_ALLOWED = false;
        }
        HostAddress hostAddress = null;
        if (inetAddress != null) {
            hostAddress = new HostAddress(inetAddress);
        }
        if (!(hostAddress == null && this.KDC_EMPTY_ADDRESSES_ALLOWED || encTicketPart.caddr == null)) {
            if (hostAddress == null) {
                throw new KrbApErrException(38);
            }
            if (!encTicketPart.caddr.inList(hostAddress)) {
                throw new KrbApErrException(38);
            }
        }
        KerberosTime kerberosTime2 = new KerberosTime(true);
        if (encTicketPart.starttime != null && encTicketPart.starttime.greaterThanWRTClockSkew(kerberosTime2) || encTicketPart.flags.get(7)) {
            throw new KrbApErrException(33);
        }
        if (encTicketPart.endtime != null && kerberosTime2.greaterThanWRTClockSkew(encTicketPart.endtime)) {
            throw new KrbApErrException(32);
        }
        this.creds = new Credentials(this.apReqMessg.ticket, this.authenticator.cname, this.apReqMessg.ticket.sname, encTicketPart.key, null, encTicketPart.authtime, encTicketPart.starttime, encTicketPart.endtime, encTicketPart.renewTill, encTicketPart.caddr);
        if (DEBUG) {
            System.out.println(">>> KrbApReq: authenticate succeed.");
        }
    }

    public Credentials getCreds() {
        return this.creds;
    }

    KerberosTime getCtime() {
        if (this.ctime != null) {
            return this.ctime;
        }
        return this.authenticator.ctime;
    }

    int cusec() {
        return this.cusec;
    }

    APOptions getAPOptions() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions;
        }
        return null;
    }

    public boolean getMutualAuthRequired() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(2);
        }
        return false;
    }

    boolean useSessionKey() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(1);
        }
        return false;
    }

    public EncryptionKey getSubKey() {
        return this.authenticator.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.authenticator.getSeqNumber();
    }

    public Checksum getChecksum() {
        return this.authenticator.getChecksum();
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    public PrincipalName getClient() {
        return this.creds.getClient();
    }

    private void createMessage(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData, int n) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n2 = null;
        if (seqNumber != null) {
            n2 = new Integer(seqNumber.current());
        }
        this.authenticator = new Authenticator(realm, principalName, checksum, kerberosTime.getMicroSeconds(), kerberosTime, encryptionKey2, n2, authorizationData);
        byte[] byArray = this.authenticator.asn1Encode();
        EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, n);
        this.apReqMessg = new APReq(aPOptions, ticket, encryptedData);
    }

    private static void checkPermittedEType(int n) throws KrbException {
        int[] nArray = EType.getDefaults("permitted_enctypes");
        if (nArray == null) {
            throw new KrbException("No supported encryption types listed in permitted_enctypes");
        }
        if (!EType.isSupported(n, nArray)) {
            throw new KrbException(EType.toString(n) + " encryption type not in permitted_enctypes list");
        }
    }
}

