/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbAsReq;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.KrbKdcRep;
import ghostfucker.utils.sun.security.krb5.internal.ASRep;
import ghostfucker.utils.sun.security.krb5.internal.ASReq;
import ghostfucker.utils.sun.security.krb5.internal.EncASRepPart;
import ghostfucker.utils.sun.security.krb5.internal.KRBError;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.krb5.internal.ccache.Credentials;
import ghostfucker.utils.sun.security.krb5.internal.crypto.EType;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;

public class KrbAsRep
extends KrbKdcRep {
    private ASRep rep;
    private ghostfucker.utils.sun.security.krb5.Credentials creds;
    private boolean DEBUG = Krb5.DEBUG;

    KrbAsRep(byte[] byArray, EncryptionKey[] encryptionKeyArray, KrbAsReq krbAsReq) throws KrbException, Asn1Exception, IOException {
        if (encryptionKeyArray == null) {
            throw new KrbException(400);
        }
        DerValue derValue = new DerValue(byArray);
        ASReq aSReq = krbAsReq.getMessage();
        ASRep aSRep = null;
        try {
            aSRep = new ASRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            KrbException krbException;
            aSRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = null;
            if (string != null && string.length() > 0) {
                string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            }
            if (string2 == null) {
                krbException = new KrbException(kRBError);
            } else {
                if (this.DEBUG) {
                    System.out.println("KRBError received: " + string2);
                }
                krbException = new KrbException(kRBError, string2);
            }
            krbException.initCause(asn1Exception);
            throw krbException;
        }
        int n = aSRep.encPart.getEType();
        EncryptionKey encryptionKey = EncryptionKey.findKey(n, encryptionKeyArray);
        if (encryptionKey == null) {
            throw new KrbException(400, "Cannot find key of appropriate type to decrypt AS REP - " + EType.toString(n));
        }
        byte[] byArray2 = aSRep.encPart.decrypt(encryptionKey, 3);
        byte[] byArray3 = aSRep.encPart.reset(byArray2, true);
        derValue = new DerValue(byArray3);
        EncASRepPart encASRepPart = new EncASRepPart(derValue);
        aSRep.ticket.sname.setRealm(aSRep.ticket.realm);
        aSRep.encKDCRepPart = encASRepPart;
        KrbAsRep.check(aSReq, aSRep);
        this.creds = new ghostfucker.utils.sun.security.krb5.Credentials(aSRep.ticket, aSReq.reqBody.cname, aSRep.ticket.sname, encASRepPart.key, encASRepPart.flags, encASRepPart.authtime, encASRepPart.starttime, encASRepPart.endtime, encASRepPart.renewTill, encASRepPart.caddr);
        if (this.DEBUG) {
            System.out.println(">>> KrbAsRep cons in KrbAsReq.getReply " + aSReq.reqBody.cname.getNameString());
        }
        this.rep = aSRep;
        this.creds = this.creds;
    }

    public ghostfucker.utils.sun.security.krb5.Credentials getCreds() {
        return this.creds;
    }

    public Credentials setCredentials() {
        return new Credentials(this.rep);
    }
}

