/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Credentials;
import ghostfucker.utils.sun.security.krb5.EncryptedData;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.KrbTgsReq;
import ghostfucker.utils.sun.security.krb5.PrincipalName;
import ghostfucker.utils.sun.security.krb5.Realm;
import ghostfucker.utils.sun.security.krb5.internal.EncKrbCredPart;
import ghostfucker.utils.sun.security.krb5.internal.HostAddresses;
import ghostfucker.utils.sun.security.krb5.internal.KDCOptions;
import ghostfucker.utils.sun.security.krb5.internal.KRBCred;
import ghostfucker.utils.sun.security.krb5.internal.KerberosTime;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.krb5.internal.KrbCredInfo;
import ghostfucker.utils.sun.security.krb5.internal.Ticket;
import ghostfucker.utils.sun.security.krb5.internal.TicketFlags;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;

public class KrbCred {
    private static boolean DEBUG = Krb5.DEBUG;
    private byte[] obuf = null;
    private KRBCred credMessg = null;
    private Ticket ticket = null;
    private EncKrbCredPart encPart = null;
    private Credentials creds = null;
    private KerberosTime timeStamp = null;

    public KrbCred(Credentials credentials, Credentials credentials2, EncryptionKey encryptionKey) throws KrbException, IOException {
        PrincipalName principalName = credentials.getClient();
        PrincipalName principalName2 = credentials.getServer();
        PrincipalName principalName3 = credentials2.getServer();
        if (!credentials2.getClient().equals(principalName)) {
            throw new KrbException(60, "Client principal does not match");
        }
        KDCOptions kDCOptions = new KDCOptions();
        kDCOptions.set(2, true);
        kDCOptions.set(1, true);
        HostAddresses hostAddresses = null;
        if (principalName3.getNameType() == 3) {
            hostAddresses = new HostAddresses(principalName3);
        }
        KrbTgsReq krbTgsReq = new KrbTgsReq(kDCOptions, credentials, principalName2, null, null, null, null, hostAddresses, null, null, null);
        this.credMessg = this.createMessage(krbTgsReq.sendAndGetCreds(), encryptionKey);
        this.obuf = this.credMessg.asn1Encode();
    }

    KRBCred createMessage(Credentials credentials, EncryptionKey encryptionKey) throws KrbException, IOException {
        EncryptionKey encryptionKey2 = credentials.getSessionKey();
        PrincipalName principalName = credentials.getClient();
        Realm realm = principalName.getRealm();
        PrincipalName principalName2 = credentials.getServer();
        Realm realm2 = principalName2.getRealm();
        KrbCredInfo krbCredInfo = new KrbCredInfo(encryptionKey2, realm, principalName, credentials.flags, credentials.authTime, credentials.startTime, credentials.endTime, credentials.renewTill, realm2, principalName2, credentials.cAddr);
        this.timeStamp = new KerberosTime(true);
        KrbCredInfo[] krbCredInfoArray = new KrbCredInfo[]{krbCredInfo};
        EncKrbCredPart encKrbCredPart = new EncKrbCredPart(krbCredInfoArray, this.timeStamp, null, null, null, null);
        EncryptedData encryptedData = new EncryptedData(encryptionKey, encKrbCredPart.asn1Encode(), 14);
        Ticket[] ticketArray = new Ticket[]{credentials.ticket};
        this.credMessg = new KRBCred(ticketArray, encryptedData);
        return this.credMessg;
    }

    public KrbCred(byte[] byArray, EncryptionKey encryptionKey) throws KrbException, IOException {
        this.credMessg = new KRBCred(byArray);
        this.ticket = this.credMessg.tickets[0];
        byte[] byArray2 = this.credMessg.encPart.decrypt(encryptionKey, 14);
        byte[] byArray3 = this.credMessg.encPart.reset(byArray2, true);
        DerValue derValue = new DerValue(byArray3);
        EncKrbCredPart encKrbCredPart = new EncKrbCredPart(derValue);
        this.timeStamp = encKrbCredPart.timeStamp;
        KrbCredInfo krbCredInfo = encKrbCredPart.ticketInfo[0];
        EncryptionKey encryptionKey2 = krbCredInfo.key;
        Realm realm = krbCredInfo.prealm;
        PrincipalName principalName = krbCredInfo.pname;
        principalName.setRealm(realm);
        TicketFlags ticketFlags = krbCredInfo.flags;
        KerberosTime kerberosTime = krbCredInfo.authtime;
        KerberosTime kerberosTime2 = krbCredInfo.starttime;
        KerberosTime kerberosTime3 = krbCredInfo.endtime;
        KerberosTime kerberosTime4 = krbCredInfo.renewTill;
        Realm realm2 = krbCredInfo.srealm;
        PrincipalName principalName2 = krbCredInfo.sname;
        principalName2.setRealm(realm2);
        HostAddresses hostAddresses = krbCredInfo.caddr;
        if (DEBUG) {
            System.out.println(">>>Delegated Creds have pname=" + principalName + " sname=" + principalName2 + " authtime=" + kerberosTime + " starttime=" + kerberosTime2 + " endtime=" + kerberosTime3 + "renewTill=" + kerberosTime4);
        }
        this.creds = new Credentials(this.ticket, principalName, principalName2, encryptionKey2, ticketFlags, kerberosTime, kerberosTime2, kerberosTime3, kerberosTime4, hostAddresses);
    }

    public Credentials[] getDelegatedCreds() {
        Credentials[] credentialsArray = new Credentials[]{this.creds};
        return credentialsArray;
    }

    public byte[] getMessage() {
        return this.obuf;
    }
}

