/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.Credentials;
import ghostfucker.utils.sun.security.krb5.EncryptedData;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbAppMessage;
import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.PrincipalName;
import ghostfucker.utils.sun.security.krb5.Realm;
import ghostfucker.utils.sun.security.krb5.internal.EncKrbPrivPart;
import ghostfucker.utils.sun.security.krb5.internal.HostAddress;
import ghostfucker.utils.sun.security.krb5.internal.KRBPriv;
import ghostfucker.utils.sun.security.krb5.internal.KdcErrException;
import ghostfucker.utils.sun.security.krb5.internal.KerberosTime;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.krb5.internal.SeqNumber;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;

class KrbPriv
extends KrbAppMessage {
    private byte[] obuf;
    private byte[] userData;

    private KrbPriv(byte[] byArray, Credentials credentials, EncryptionKey encryptionKey, KerberosTime kerberosTime, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2) throws KrbException, IOException {
        EncryptionKey encryptionKey2 = null;
        encryptionKey2 = encryptionKey != null ? encryptionKey : credentials.key;
        this.obuf = this.mk_priv(byArray, encryptionKey2, kerberosTime, seqNumber, hostAddress, hostAddress2);
    }

    private KrbPriv(byte[] byArray, Credentials credentials, EncryptionKey encryptionKey, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2, boolean bl, boolean bl2) throws KrbException, IOException {
        KRBPriv kRBPriv = new KRBPriv(byArray);
        EncryptionKey encryptionKey2 = null;
        encryptionKey2 = encryptionKey != null ? encryptionKey : credentials.key;
        this.userData = this.rd_priv(kRBPriv, encryptionKey2, seqNumber, hostAddress, hostAddress2, bl, bl2, credentials.client, credentials.client.getRealm());
    }

    public byte[] getMessage() throws KrbException {
        return this.obuf;
    }

    public byte[] getData() {
        return this.userData;
    }

    private byte[] mk_priv(byte[] byArray, EncryptionKey encryptionKey, KerberosTime kerberosTime, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n = null;
        Integer n2 = null;
        if (kerberosTime != null) {
            n = new Integer(kerberosTime.getMicroSeconds());
        }
        if (seqNumber != null) {
            n2 = new Integer(seqNumber.current());
            seqNumber.step();
        }
        EncKrbPrivPart encKrbPrivPart = new EncKrbPrivPart(byArray, kerberosTime, n, n2, hostAddress, hostAddress2);
        byte[] byArray2 = encKrbPrivPart.asn1Encode();
        EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray2, 13);
        KRBPriv kRBPriv = new KRBPriv(encryptedData);
        byArray2 = kRBPriv.asn1Encode();
        return kRBPriv.asn1Encode();
    }

    private byte[] rd_priv(KRBPriv kRBPriv, EncryptionKey encryptionKey, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2, boolean bl, boolean bl2, PrincipalName principalName, Realm realm) throws Asn1Exception, KdcErrException, KrbApErrException, IOException, KrbCryptoException {
        byte[] byArray = kRBPriv.encPart.decrypt(encryptionKey, 13);
        byte[] byArray2 = kRBPriv.encPart.reset(byArray, true);
        DerValue derValue = new DerValue(byArray2);
        EncKrbPrivPart encKrbPrivPart = new EncKrbPrivPart(derValue);
        this.check(encKrbPrivPart.timestamp, encKrbPrivPart.usec, encKrbPrivPart.seqNumber, encKrbPrivPart.sAddress, encKrbPrivPart.rAddress, seqNumber, hostAddress, hostAddress2, bl, bl2, principalName, realm);
        return encKrbPrivPart.userData;
    }
}

