/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.Checksum;
import ghostfucker.utils.sun.security.krb5.Credentials;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbAppMessage;
import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.PrincipalName;
import ghostfucker.utils.sun.security.krb5.Realm;
import ghostfucker.utils.sun.security.krb5.internal.HostAddress;
import ghostfucker.utils.sun.security.krb5.internal.KRBSafe;
import ghostfucker.utils.sun.security.krb5.internal.KRBSafeBody;
import ghostfucker.utils.sun.security.krb5.internal.KdcErrException;
import ghostfucker.utils.sun.security.krb5.internal.KerberosTime;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.krb5.internal.SeqNumber;
import java.io.IOException;

class KrbSafe
extends KrbAppMessage {
    private byte[] obuf;
    private byte[] userData;

    public KrbSafe(byte[] byArray, Credentials credentials, EncryptionKey encryptionKey, KerberosTime kerberosTime, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2) throws KrbException, IOException {
        EncryptionKey encryptionKey2 = null;
        encryptionKey2 = encryptionKey != null ? encryptionKey : credentials.key;
        this.obuf = this.mk_safe(byArray, encryptionKey2, kerberosTime, seqNumber, hostAddress, hostAddress2);
    }

    public KrbSafe(byte[] byArray, Credentials credentials, EncryptionKey encryptionKey, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2, boolean bl, boolean bl2) throws KrbException, IOException {
        KRBSafe kRBSafe = new KRBSafe(byArray);
        EncryptionKey encryptionKey2 = null;
        encryptionKey2 = encryptionKey != null ? encryptionKey : credentials.key;
        this.userData = this.rd_safe(kRBSafe, encryptionKey2, seqNumber, hostAddress, hostAddress2, bl, bl2, credentials.client, credentials.client.getRealm());
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    public byte[] getData() {
        return this.userData;
    }

    private byte[] mk_safe(byte[] byArray, EncryptionKey encryptionKey, KerberosTime kerberosTime, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2) throws Asn1Exception, IOException, KdcErrException, KrbApErrException, KrbCryptoException {
        Integer n = null;
        Integer n2 = null;
        if (kerberosTime != null) {
            n = new Integer(kerberosTime.getMicroSeconds());
        }
        if (seqNumber != null) {
            n2 = new Integer(seqNumber.current());
            seqNumber.step();
        }
        KRBSafeBody kRBSafeBody = new KRBSafeBody(byArray, kerberosTime, n, n2, hostAddress, hostAddress2);
        byte[] byArray2 = kRBSafeBody.asn1Encode();
        Checksum checksum = new Checksum(Checksum.SAFECKSUMTYPE_DEFAULT, byArray2, encryptionKey, 15);
        KRBSafe kRBSafe = new KRBSafe(kRBSafeBody, checksum);
        byArray2 = kRBSafe.asn1Encode();
        return kRBSafe.asn1Encode();
    }

    private byte[] rd_safe(KRBSafe kRBSafe, EncryptionKey encryptionKey, SeqNumber seqNumber, HostAddress hostAddress, HostAddress hostAddress2, boolean bl, boolean bl2, PrincipalName principalName, Realm realm) throws Asn1Exception, KdcErrException, KrbApErrException, IOException, KrbCryptoException {
        byte[] byArray = kRBSafe.safeBody.asn1Encode();
        if (!kRBSafe.cksum.verifyKeyedChecksum(byArray, encryptionKey, 15)) {
            throw new KrbApErrException(41);
        }
        this.check(kRBSafe.safeBody.timestamp, kRBSafe.safeBody.usec, kRBSafe.safeBody.seqNumber, kRBSafe.safeBody.sAddress, kRBSafe.safeBody.rAddress, seqNumber, hostAddress, hostAddress2, bl, bl2, principalName, realm);
        return kRBSafe.safeBody.userData;
    }
}

