/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.KrbKdcRep;
import ghostfucker.utils.sun.security.krb5.KrbTgsReq;
import ghostfucker.utils.sun.security.krb5.internal.EncTGSRepPart;
import ghostfucker.utils.sun.security.krb5.internal.KRBError;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.krb5.internal.TGSRep;
import ghostfucker.utils.sun.security.krb5.internal.TGSReq;
import ghostfucker.utils.sun.security.krb5.internal.Ticket;
import ghostfucker.utils.sun.security.krb5.internal.ccache.Credentials;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;

public class KrbTgsRep
extends KrbKdcRep {
    private TGSRep rep;
    private ghostfucker.utils.sun.security.krb5.Credentials creds;
    private Ticket secondTicket;
    private static final boolean DEBUG = Krb5.DEBUG;

    KrbTgsRep(byte[] byArray, KrbTgsReq krbTgsReq) throws KrbException, IOException {
        DerValue derValue = new DerValue(byArray);
        TGSReq tGSReq = krbTgsReq.getMessage();
        TGSRep tGSRep = null;
        try {
            tGSRep = new TGSRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            tGSRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = null;
            if (string != null && string.length() > 0) {
                string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            }
            KrbException krbException = string2 == null ? new KrbException(kRBError.getErrorCode()) : new KrbException(kRBError.getErrorCode(), string2);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
        byte[] byArray2 = tGSRep.encPart.decrypt(krbTgsReq.tgsReqKey, krbTgsReq.usedSubkey() ? 9 : 8);
        byte[] byArray3 = tGSRep.encPart.reset(byArray2, true);
        derValue = new DerValue(byArray3);
        EncTGSRepPart encTGSRepPart = new EncTGSRepPart(derValue);
        tGSRep.ticket.sname.setRealm(tGSRep.ticket.realm);
        tGSRep.encKDCRepPart = encTGSRepPart;
        KrbTgsRep.check(tGSReq, tGSRep);
        this.creds = new ghostfucker.utils.sun.security.krb5.Credentials(tGSRep.ticket, tGSReq.reqBody.cname, tGSRep.ticket.sname, encTGSRepPart.key, encTGSRepPart.flags, encTGSRepPart.authtime, encTGSRepPart.starttime, encTGSRepPart.endtime, encTGSRepPart.renewTill, encTGSRepPart.caddr);
        this.rep = tGSRep;
        this.creds = this.creds;
        this.secondTicket = krbTgsReq.getSecondTicket();
    }

    public ghostfucker.utils.sun.security.krb5.Credentials getCreds() {
        return this.creds;
    }

    Credentials setCredentials() {
        return new Credentials(this.rep, this.secondTicket);
    }
}

