/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.Config;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.RealmException;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Realm
implements Cloneable {
    private String realm;
    private static boolean DEBUG = Krb5.DEBUG;

    private Realm() {
    }

    public Realm(String string) throws RealmException {
        this.realm = Realm.parseRealm(string);
    }

    public Object clone() {
        Realm realm = new Realm();
        if (this.realm != null) {
            realm.realm = new String(this.realm);
        }
        return realm;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Realm)) {
            return false;
        }
        Realm realm = (Realm)object;
        if (this.realm != null && realm.realm != null) {
            return this.realm.equals(realm.realm);
        }
        return this.realm == null && realm.realm == null;
    }

    public int hashCode() {
        int n = 17;
        if (this.realm != null) {
            n = 37 * n + this.realm.hashCode();
        }
        return n;
    }

    public Realm(DerValue derValue) throws Asn1Exception, RealmException, IOException {
        if (derValue == null) {
            throw new IllegalArgumentException("encoding can not be null");
        }
        this.realm = derValue.getGeneralString();
        if (this.realm == null || this.realm.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(this.realm)) {
            throw new RealmException(600);
        }
    }

    public String toString() {
        return this.realm;
    }

    public static String parseRealmAtSeparator(String string) throws RealmException {
        if (string == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String string2 = new String(string);
        String string3 = null;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != '@' || i != 0 && string2.charAt(i - 1) == '\\') continue;
            if (i + 1 >= string2.length()) break;
            string3 = string2.substring(i + 1, string2.length());
            break;
        }
        if (string3 != null) {
            if (string3.length() == 0) {
                throw new RealmException(601);
            }
            if (!Realm.isValidRealmString(string3)) {
                throw new RealmException(600);
            }
        }
        return string3;
    }

    protected static String parseRealm(String string) throws RealmException {
        String string2 = Realm.parseRealmAtSeparator(string);
        if (string2 == null) {
            string2 = string;
        }
        if (string2 == null || string2.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(string2)) {
            throw new RealmException(600);
        }
        return string2;
    }

    protected static boolean isValidRealmString(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '/' && string.charAt(i) != ':' && string.charAt(i) != '\u0000') continue;
            return false;
        }
        return true;
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putGeneralString(this.realm);
        return derOutputStream.toByteArray();
    }

    public static Realm parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException, RealmException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Realm(derValue2);
    }

    private static String[] doInitialParse(String string, String string2) throws KrbException {
        if (string == null || string2 == null) {
            throw new KrbException(400);
        }
        if (DEBUG) {
            System.out.println(">>> Realm doInitialParse: cRealm=[" + string + "], sRealm=[" + string2 + "]");
        }
        if (string.equals(string2)) {
            String[] stringArray = null;
            stringArray = new String[]{new String(string)};
            if (DEBUG) {
                System.out.println(">>> Realm doInitialParse: " + stringArray[0]);
            }
            return stringArray;
        }
        return null;
    }

    public static String[] getRealmsList(String string, String string2) throws KrbException {
        String[] stringArray = Realm.doInitialParse(string, string2);
        if (stringArray != null && stringArray.length != 0) {
            return stringArray;
        }
        stringArray = Realm.parseCapaths(string, string2);
        if (stringArray != null && stringArray.length != 0) {
            return stringArray;
        }
        stringArray = Realm.parseHierarchy(string, string2);
        return stringArray;
    }

    private static String[] parseCapaths(String string, String string2) throws KrbException {
        String[] stringArray = null;
        Config config = null;
        try {
            config = Config.getInstance();
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("Configuration information can not be obtained " + exception.getMessage());
            }
            return null;
        }
        String string3 = config.getDefault(string2, string);
        if (string3 == null) {
            if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: no cfg entry");
            }
            return null;
        }
        String string4 = null;
        String string5 = null;
        StringTokenizer stringTokenizer = null;
        Stack<String> stack = new Stack<String>();
        Vector<String> vector = new Vector<String>(8, 8);
        vector.add(string);
        int n = 0;
        if (DEBUG) {
            string4 = string2;
        }
        while (true) {
            if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: loop " + ++n + ": target=" + string4);
            }
            if (string3 != null && !string3.equals(".")) {
                if (DEBUG) {
                    System.out.println(">>> Realm parseCapaths: loop " + n + ": intermediaries=[" + string3 + "]");
                }
                stringTokenizer = new StringTokenizer(string3, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    if (!string5.equals(".") && !stack.contains(string5)) {
                        stack.push(string5);
                        if (!DEBUG) continue;
                        System.out.println(">>> Realm parseCapaths: loop " + n + ": pushed realm on to stack: " + string5);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.out.println(">>> Realm parseCapaths: loop " + n + ": ignoring realm: [" + string5 + "]");
                }
            } else if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: loop " + n + ": no intermediaries");
            }
            try {
                string4 = (String)stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                string4 = null;
            }
            if (string4 == null) break;
            vector.add(string4);
            if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: loop " + n + ": added intermediary to list: " + string4);
            }
            string3 = config.getDefault(string4, string);
        }
        stringArray = new String[vector.size()];
        try {
            stringArray = vector.toArray(stringArray);
        }
        catch (ArrayStoreException arrayStoreException) {
            stringArray = null;
        }
        if (DEBUG && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(">>> Realm parseCapaths [" + i + "]=" + stringArray[i]);
            }
        }
        return stringArray;
    }

    private static String[] parseHierarchy(String string, String string2) throws KrbException {
        String string3;
        int n;
        int n2;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n3 = stringTokenizer.countTokens();
        stringArray2 = new String[n3];
        n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy: cRealm has " + n3 + " components:");
            n2 = 0;
            while (n2 < n3) {
                System.out.println(">>> Realm parseHierarchy: cComponents[" + n2 + "]=" + stringArray2[n2++]);
            }
        }
        stringTokenizer = new StringTokenizer(string2, ".");
        n2 = stringTokenizer.countTokens();
        stringArray3 = new String[n2];
        n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray3[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy: sRealm has " + n2 + " components:");
            n = 0;
            while (n < n2) {
                System.out.println(">>> Realm parseHierarchy: sComponents[" + n + "]=" + stringArray3[n++]);
            }
        }
        n = 0;
        --n2;
        --n3;
        while (n2 >= 0 && n3 >= 0 && stringArray3[n2].equals(stringArray2[n3])) {
            ++n;
            --n2;
            --n3;
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        if (n > 0) {
            n5 = n2 + 1;
            n4 = n3 + 1;
            n6 += n5;
            n6 += n4;
        } else {
            ++n6;
        }
        if (DEBUG) {
            if (n > 0) {
                System.out.println(">>> Realm parseHierarchy: " + n + " common component" + (n > 1 ? "s" : " "));
                System.out.println(">>> Realm parseHierarchy: common part in cRealm (starts at index " + n4 + ")");
                System.out.println(">>> Realm parseHierarchy: common part in sRealm (starts at index " + n5 + ")");
                string3 = Realm.substring(string, n4);
                System.out.println(">>> Realm parseHierarchy: common part in cRealm=" + string3);
                string3 = Realm.substring(string2, n5);
                System.out.println(">>> Realm parseHierarchy: common part in sRealm=" + string3);
            } else {
                System.out.println(">>> Realm parseHierarchy: no common part");
            }
        }
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy: total links=" + n6);
        }
        stringArray = new String[n6];
        stringArray[0] = new String(string);
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy A: retList[0]=" + stringArray[0]);
        }
        string3 = null;
        String string4 = null;
        int n7 = 1;
        for (n3 = 0; n7 < n6 && n3 < n4; ++n3) {
            string4 = Realm.substring(string, n3 + 1);
            stringArray[n7++] = new String(string4);
            if (!DEBUG) continue;
            System.out.println(">>> Realm parseHierarchy B: retList[" + (n7 - 1) + "]=" + stringArray[n7 - 1]);
        }
        n2 = n5;
        while (n7 < n6 && n2 - 1 > 0) {
            string4 = Realm.substring(string2, n2 - 1);
            stringArray[n7++] = new String(string4);
            if (DEBUG) {
                System.out.println(">>> Realm parseHierarchy D: retList[" + (n7 - 1) + "]=" + stringArray[n7 - 1]);
            }
            --n2;
        }
        return stringArray;
    }

    private static String substring(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n2 < n4 && n3 != n) {
            if (string.charAt(n2++) != '.') continue;
            ++n3;
        }
        return string.substring(n2);
    }

    static int getRandIndex(int n) {
        return (int)(Math.random() * 16384.0) % n;
    }

    static void printNames(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = stringArray.length;
        System.out.println("List length = " + n);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("[" + i + "]=" + stringArray[i]);
        }
    }
}

