/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.EncryptedData;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class APRep {
    public int pvno;
    public int msgType;
    public EncryptedData encPart;

    public APRep(EncryptedData encryptedData) {
        this.pvno = 5;
        this.msgType = 15;
        this.encPart = encryptedData;
    }

    public APRep(byte[] byArray) throws Asn1Exception, KrbApErrException, IOException {
        this.init(new DerValue(byArray));
    }

    public APRep(DerValue derValue) throws Asn1Exception, KrbApErrException, IOException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 15 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.pvno = derValue3.getData().getBigInteger().intValue();
        if (this.pvno != 5) {
            throw new KrbApErrException(39);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.msgType = derValue3.getData().getBigInteger().intValue();
        if (this.msgType != 15) {
            throw new KrbApErrException(40);
        }
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)2, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), this.encPart.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, true, (byte)15), derOutputStream2);
        return derOutputStream3.toByteArray();
    }
}

