/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.internal.AuthorizationDataEntry;
import ghostfucker.utils.sun.security.krb5.internal.ccache.CCacheOutputStream;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.util.Vector;

public class AuthorizationData
implements Cloneable {
    private AuthorizationDataEntry[] entry = null;

    private AuthorizationData() {
    }

    public AuthorizationData(AuthorizationDataEntry[] authorizationDataEntryArray) throws IOException {
        if (authorizationDataEntryArray != null) {
            this.entry = new AuthorizationDataEntry[authorizationDataEntryArray.length];
            for (int i = 0; i < authorizationDataEntryArray.length; ++i) {
                if (authorizationDataEntryArray[i] == null) {
                    throw new IOException("Cannot create an AuthorizationData");
                }
                this.entry[i] = (AuthorizationDataEntry)authorizationDataEntryArray[i].clone();
            }
        }
    }

    public AuthorizationData(AuthorizationDataEntry authorizationDataEntry) {
        this.entry = new AuthorizationDataEntry[1];
        this.entry[0] = authorizationDataEntry;
    }

    public Object clone() {
        AuthorizationData authorizationData = new AuthorizationData();
        if (this.entry != null) {
            authorizationData.entry = new AuthorizationDataEntry[this.entry.length];
            for (int i = 0; i < this.entry.length; ++i) {
                authorizationData.entry[i] = (AuthorizationDataEntry)this.entry[i].clone();
            }
        }
        return authorizationData;
    }

    public AuthorizationData(DerValue derValue) throws Asn1Exception, IOException {
        Vector<AuthorizationDataEntry> vector = new Vector<AuthorizationDataEntry>();
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (derValue.getData().available() > 0) {
            vector.addElement(new AuthorizationDataEntry(derValue.getData().getDerValue()));
        }
        if (vector.size() > 0) {
            this.entry = new AuthorizationDataEntry[vector.size()];
            vector.copyInto(this.entry);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[this.entry.length];
        for (int i = 0; i < this.entry.length; ++i) {
            derValueArray[i] = new DerValue(this.entry[i].asn1Encode());
        }
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    public static AuthorizationData parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new AuthorizationData(derValue2);
    }

    public void writeAuth(CCacheOutputStream cCacheOutputStream) throws IOException {
        for (int i = 0; i < this.entry.length; ++i) {
            this.entry[i].writeEntry(cCacheOutputStream);
        }
    }

    public String toString() {
        String string = "AuthorizationData:\n";
        for (int i = 0; i < this.entry.length; ++i) {
            string = string + this.entry[i].toString();
        }
        return string;
    }
}

