/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;

public class ETypeInfo {
    private int etype;
    private byte[] salt = null;
    private static final byte TAG_TYPE = 0;
    private static final byte TAG_VALUE = 1;

    private ETypeInfo() {
    }

    public ETypeInfo(int n, byte[] byArray) {
        this.etype = n;
        if (byArray != null) {
            this.salt = (byte[])byArray.clone();
        }
    }

    public Object clone() {
        ETypeInfo eTypeInfo = new ETypeInfo();
        eTypeInfo.etype = this.etype;
        if (this.salt != null) {
            eTypeInfo.salt = new byte[this.salt.length];
            System.arraycopy(this.salt, 0, eTypeInfo.salt, 0, this.salt.length);
        }
        return eTypeInfo;
    }

    public ETypeInfo(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.etype = derValue2.getData().getBigInteger().intValue();
        if (derValue.getData().available() > 0 && ((derValue2 = derValue.getData().getDerValue()).getTag() & 0x1F) == 1) {
            this.salt = derValue2.getData().getOctetString();
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.etype);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        if (this.salt != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOctetString(this.salt);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public int getEType() {
        return this.etype;
    }

    public byte[] getSalt() {
        return this.salt == null ? null : (byte[])this.salt.clone();
    }
}

