/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.RealmException;
import ghostfucker.utils.sun.security.krb5.internal.HostAddress;
import ghostfucker.utils.sun.security.krb5.internal.HostAddresses;
import ghostfucker.utils.sun.security.krb5.internal.KerberosTime;
import ghostfucker.utils.sun.security.krb5.internal.KrbCredInfo;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class EncKrbCredPart {
    public KrbCredInfo[] ticketInfo = null;
    public KerberosTime timeStamp;
    private Integer nonce;
    private Integer usec;
    private HostAddress sAddress;
    private HostAddresses rAddress;

    public EncKrbCredPart(KrbCredInfo[] krbCredInfoArray, KerberosTime kerberosTime, Integer n, Integer n2, HostAddress hostAddress, HostAddresses hostAddresses) throws IOException {
        if (krbCredInfoArray != null) {
            this.ticketInfo = new KrbCredInfo[krbCredInfoArray.length];
            for (int i = 0; i < krbCredInfoArray.length; ++i) {
                if (krbCredInfoArray[i] == null) {
                    throw new IOException("Cannot create a EncKrbCredPart");
                }
                this.ticketInfo[i] = (KrbCredInfo)krbCredInfoArray[i].clone();
            }
        }
        this.timeStamp = kerberosTime;
        this.usec = n;
        this.nonce = n2;
        this.sAddress = hostAddress;
        this.rAddress = hostAddresses;
    }

    public EncKrbCredPart(byte[] byArray) throws Asn1Exception, IOException, RealmException {
        this.init(new DerValue(byArray));
    }

    public EncKrbCredPart(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.nonce = null;
        this.timeStamp = null;
        this.usec = null;
        this.sAddress = null;
        this.rAddress = null;
        if ((derValue.getTag() & 0x1F) != 29 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            DerValue[] derValueArray = derValue3.getData().getSequence(1);
            this.ticketInfo = new KrbCredInfo[derValueArray.length];
            for (int i = 0; i < derValueArray.length; ++i) {
                this.ticketInfo[i] = new KrbCredInfo(derValueArray[i]);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if (derValue2.getData().available() > 0 && ((byte)derValue2.getData().peekByte() & 0x1F) == 1) {
            derValue3 = derValue2.getData().getDerValue();
            this.nonce = new Integer(derValue3.getData().getBigInteger().intValue());
        }
        if (derValue2.getData().available() > 0) {
            this.timeStamp = KerberosTime.parse(derValue2.getData(), (byte)2, true);
        }
        if (derValue2.getData().available() > 0 && ((byte)derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.usec = new Integer(derValue3.getData().getBigInteger().intValue());
        }
        if (derValue2.getData().available() > 0) {
            this.sAddress = HostAddress.parse(derValue2.getData(), (byte)4, true);
        }
        if (derValue2.getData().available() > 0) {
            this.rAddress = HostAddresses.parse(derValue2.getData(), (byte)5, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[this.ticketInfo.length];
        for (int i = 0; i < this.ticketInfo.length; ++i) {
            derValueArray[i] = new DerValue(this.ticketInfo[i].asn1Encode());
        }
        derOutputStream2.putSequence(derValueArray);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        if (this.nonce != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.nonce.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
        if (this.timeStamp != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), this.timeStamp.asn1Encode());
        }
        if (this.usec != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.usec.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream2);
        }
        if (this.sAddress != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)4), this.sAddress.asn1Encode());
        }
        if (this.rAddress != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)5), this.rAddress.asn1Encode());
        }
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, true, (byte)29), derOutputStream2);
        return derOutputStream.toByteArray();
    }
}

