/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostAddress
implements Cloneable {
    int addrType;
    byte[] address = null;
    private static InetAddress localInetAddress;
    private static final boolean DEBUG;
    private volatile int hashCode = 0;

    private HostAddress(int n) {
    }

    public Object clone() {
        HostAddress hostAddress = new HostAddress(0);
        hostAddress.addrType = this.addrType;
        if (this.address != null) {
            hostAddress.address = (byte[])this.address.clone();
        }
        return hostAddress;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this.addrType;
            if (this.address != null) {
                for (int i = 0; i < this.address.length; ++i) {
                    n = 37 * n + this.address[i];
                }
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HostAddress)) {
            return false;
        }
        HostAddress hostAddress = (HostAddress)object;
        if (this.addrType != hostAddress.addrType || this.address != null && hostAddress.address == null || this.address == null && hostAddress.address != null) {
            return false;
        }
        if (this.address != null && hostAddress.address != null) {
            if (this.address.length != hostAddress.address.length) {
                return false;
            }
            for (int i = 0; i < this.address.length; ++i) {
                if (this.address[i] == hostAddress.address[i]) continue;
                return false;
            }
        }
        return true;
    }

    private static synchronized InetAddress getLocalInetAddress() throws UnknownHostException {
        if (localInetAddress == null) {
            localInetAddress = InetAddress.getLocalHost();
        }
        if (localInetAddress == null) {
            throw new UnknownHostException();
        }
        return localInetAddress;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.addrType == 2 || this.addrType == 24) {
            return InetAddress.getByAddress(this.address);
        }
        return null;
    }

    private int getAddrType(InetAddress inetAddress) {
        int n = 0;
        if (inetAddress instanceof Inet4Address) {
            n = 2;
        } else if (inetAddress instanceof Inet6Address) {
            n = 24;
        }
        return n;
    }

    public HostAddress() throws UnknownHostException {
        InetAddress inetAddress = HostAddress.getLocalInetAddress();
        this.addrType = this.getAddrType(inetAddress);
        this.address = inetAddress.getAddress();
    }

    public HostAddress(int n, byte[] byArray) throws KrbApErrException, UnknownHostException {
        switch (n) {
            case 2: {
                if (byArray.length == 4) break;
                throw new KrbApErrException(0, "Invalid Internet address");
            }
            case 5: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, "Invalid CHAOSnet address");
            }
            case 7: {
                break;
            }
            case 6: {
                if (byArray.length == 6) break;
                throw new KrbApErrException(0, "Invalid XNS address");
            }
            case 16: {
                if (byArray.length == 3) break;
                throw new KrbApErrException(0, "Invalid DDP address");
            }
            case 12: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, "Invalid DECnet Phase IV address");
            }
            case 24: {
                if (byArray.length == 16) break;
                throw new KrbApErrException(0, "Invalid Internet IPv6 address");
            }
        }
        this.addrType = n;
        if (byArray != null) {
            this.address = (byte[])byArray.clone();
        }
        if (DEBUG && (this.addrType == 2 || this.addrType == 24)) {
            System.out.println("Host address is " + InetAddress.getByAddress(this.address));
        }
    }

    public HostAddress(InetAddress inetAddress) {
        this.addrType = this.getAddrType(inetAddress);
        this.address = inetAddress.getAddress();
    }

    public HostAddress(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.addrType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.address = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.addrType);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.address);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddress parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddress(derValue2);
    }

    static {
        DEBUG = Krb5.DEBUG;
    }
}

