/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.EncryptedData;
import ghostfucker.utils.sun.security.krb5.PrincipalName;
import ghostfucker.utils.sun.security.krb5.Realm;
import ghostfucker.utils.sun.security.krb5.RealmException;
import ghostfucker.utils.sun.security.krb5.internal.EncKDCRepPart;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.krb5.internal.PAData;
import ghostfucker.utils.sun.security.krb5.internal.Ticket;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class KDCRep {
    public Realm crealm;
    public PrincipalName cname;
    public Ticket ticket;
    public EncryptedData encPart;
    public EncKDCRepPart encKDCRepPart;
    private int pvno;
    private int msgType;
    private PAData[] pAData = null;
    private boolean DEBUG = Krb5.DEBUG;

    public KDCRep(PAData[] pADataArray, Realm realm, PrincipalName principalName, Ticket ticket, EncryptedData encryptedData, int n) throws IOException {
        this.pvno = 5;
        this.msgType = n;
        if (pADataArray != null) {
            this.pAData = new PAData[pADataArray.length];
            for (int i = 0; i < pADataArray.length; ++i) {
                if (pADataArray[i] == null) {
                    throw new IOException("Cannot create a KDCRep");
                }
                this.pAData[i] = (PAData)pADataArray[i].clone();
            }
        }
        this.crealm = realm;
        this.cname = principalName;
        this.ticket = ticket;
        this.encPart = encryptedData;
    }

    public KDCRep() {
    }

    public KDCRep(byte[] byArray, int n) throws Asn1Exception, KrbApErrException, RealmException, IOException {
        this.init(new DerValue(byArray), n);
    }

    public KDCRep(DerValue derValue, int n) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(derValue, n);
    }

    protected void init(DerValue derValue, int n) throws Asn1Exception, RealmException, IOException, KrbApErrException {
        if ((derValue.getTag() & 0x1F) != n) {
            if (this.DEBUG) {
                System.out.println(">>> KDCRep: init() encoding tag is " + derValue.getTag() + " req type is " + n);
            }
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != n) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if ((derValue2.getData().peekByte() & 0x1F) == 2) {
            derValue3 = derValue2.getData().getDerValue();
            DerValue[] derValueArray = derValue3.getData().getSequence(1);
            this.pAData = new PAData[derValueArray.length];
            for (int i = 0; i < derValueArray.length; ++i) {
                this.pAData[i] = new PAData(derValueArray[i]);
            }
        } else {
            this.pAData = null;
        }
        this.crealm = Realm.parse(derValue2.getData(), (byte)3, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)4, false);
        this.ticket = Ticket.parse(derValue2.getData(), (byte)5, false);
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)6, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        if (this.pAData != null && this.pAData.length > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            for (int i = 0; i < this.pAData.length; ++i) {
                derOutputStream3.write(this.pAData[i].asn1Encode());
            }
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream3);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        }
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), this.crealm.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)4), this.cname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)5), this.ticket.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)6), this.encPart.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

