/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.internal.HostAddress;
import ghostfucker.utils.sun.security.krb5.internal.KerberosTime;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class KRBSafeBody {
    public byte[] userData = null;
    public KerberosTime timestamp;
    public Integer usec;
    public Integer seqNumber;
    public HostAddress sAddress;
    public HostAddress rAddress;

    public KRBSafeBody(byte[] byArray, KerberosTime kerberosTime, Integer n, Integer n2, HostAddress hostAddress, HostAddress hostAddress2) {
        if (byArray != null) {
            this.userData = (byte[])byArray.clone();
        }
        this.timestamp = kerberosTime;
        this.usec = n;
        this.seqNumber = n2;
        this.sAddress = hostAddress;
        this.rAddress = hostAddress2;
    }

    public KRBSafeBody(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.userData = derValue2.getData().getOctetString();
        this.timestamp = KerberosTime.parse(derValue.getData(), (byte)1, true);
        if ((derValue.getData().peekByte() & 0x1F) == 2) {
            derValue2 = derValue.getData().getDerValue();
            this.usec = new Integer(derValue2.getData().getBigInteger().intValue());
        }
        if ((derValue.getData().peekByte() & 0x1F) == 3) {
            derValue2 = derValue.getData().getDerValue();
            this.seqNumber = new Integer(derValue2.getData().getBigInteger().intValue());
        }
        this.sAddress = HostAddress.parse(derValue.getData(), (byte)4, false);
        if (derValue.getData().available() > 0) {
            this.rAddress = HostAddress.parse(derValue.getData(), (byte)5, true);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.userData);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        if (this.timestamp != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), this.timestamp.asn1Encode());
        }
        if (this.usec != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.usec.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        }
        if (this.seqNumber != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.seqNumber.longValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream2);
        }
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)4), this.sAddress.asn1Encode());
        if (this.rAddress != null) {
            derOutputStream2 = new DerOutputStream();
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static KRBSafeBody parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new KRBSafeBody(derValue2);
    }
}

