/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class MethodData {
    private int methodType;
    private byte[] methodData = null;

    public MethodData(int n, byte[] byArray) {
        this.methodType = n;
        if (byArray != null) {
            this.methodData = (byte[])byArray.clone();
        }
    }

    public MethodData(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        BigInteger bigInteger = derValue2.getData().getBigInteger();
        this.methodType = bigInteger.intValue();
        if (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            if ((derValue2.getTag() & 0x1F) == 1) {
                this.methodData = derValue2.getData().getOctetString();
            } else {
                throw new Asn1Exception(906);
            }
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.methodType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        if (this.methodData != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOctetString(this.methodData);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

