/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class TransitedEncoding {
    public int trType;
    public byte[] contents;

    public TransitedEncoding(int n, byte[] byArray) {
        this.trType = n;
        this.contents = byArray;
    }

    public TransitedEncoding(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.trType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.contents = derValue2.getData().getOctetString();
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.trType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.contents);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static TransitedEncoding parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new TransitedEncoding(derValue2);
    }
}

