/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal.ccache;

import ghostfucker.utils.sun.security.krb5.Asn1Exception;
import ghostfucker.utils.sun.security.krb5.PrincipalName;
import ghostfucker.utils.sun.security.krb5.internal.Ticket;
import ghostfucker.utils.sun.security.krb5.internal.TicketFlags;
import ghostfucker.utils.sun.security.krb5.internal.ccache.Credentials;
import ghostfucker.utils.sun.security.krb5.internal.ccache.FileCCacheConstants;
import ghostfucker.utils.sun.security.krb5.internal.util.KrbDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CCacheOutputStream
extends KrbDataOutputStream
implements FileCCacheConstants {
    public CCacheOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeHeader(PrincipalName principalName, int n) throws IOException {
        this.write((n & 0xFF00) >> 8);
        this.write(n & 0xFF);
        principalName.writePrincipal(this);
    }

    public void addCreds(Credentials credentials) throws IOException, Asn1Exception {
        credentials.cname.writePrincipal(this);
        credentials.sname.writePrincipal(this);
        credentials.key.writeKey(this);
        this.write32((int)(credentials.authtime.getTime() / 1000L));
        if (credentials.starttime != null) {
            this.write32((int)(credentials.starttime.getTime() / 1000L));
        } else {
            this.write32(0);
        }
        this.write32((int)(credentials.endtime.getTime() / 1000L));
        if (credentials.renewTill != null) {
            this.write32((int)(credentials.renewTill.getTime() / 1000L));
        } else {
            this.write32(0);
        }
        if (credentials.isEncInSKey) {
            this.write8(1);
        } else {
            this.write8(0);
        }
        this.writeFlags(credentials.flags);
        if (credentials.caddr == null) {
            this.write32(0);
        } else {
            credentials.caddr.writeAddrs(this);
        }
        if (credentials.authorizationData == null) {
            this.write32(0);
        } else {
            credentials.authorizationData.writeAuth(this);
        }
        this.writeTicket(credentials.ticket);
        this.writeTicket(credentials.secondTicket);
    }

    void writeTicket(Ticket ticket) throws IOException, Asn1Exception {
        if (ticket == null) {
            this.write32(0);
        } else {
            byte[] byArray = ticket.asn1Encode();
            this.write32(byArray.length);
            this.write(byArray, 0, byArray.length);
        }
    }

    void writeFlags(TicketFlags ticketFlags) throws IOException {
        int n = 0;
        boolean[] blArray = ticketFlags.toBooleanArray();
        if (blArray[1]) {
            n |= 0x40000000;
        }
        if (blArray[2]) {
            n |= 0x20000000;
        }
        if (blArray[3]) {
            n |= 0x10000000;
        }
        if (blArray[4]) {
            n |= 0x8000000;
        }
        if (blArray[5]) {
            n |= 0x4000000;
        }
        if (blArray[6]) {
            n |= 0x2000000;
        }
        if (blArray[7]) {
            n |= 0x1000000;
        }
        if (blArray[8]) {
            n |= 0x800000;
        }
        if (blArray[9]) {
            n |= 0x400000;
        }
        if (blArray[10]) {
            n |= 0x200000;
        }
        if (blArray[11]) {
            n |= 0x100000;
        }
        this.write32(n);
    }
}

