/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal.ccache;

import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.krb5.PrincipalName;
import ghostfucker.utils.sun.security.krb5.Realm;
import ghostfucker.utils.sun.security.krb5.internal.Krb5;
import ghostfucker.utils.sun.security.krb5.internal.LoginOptions;
import ghostfucker.utils.sun.security.krb5.internal.ccache.Credentials;
import ghostfucker.utils.sun.security.krb5.internal.ccache.FileCredentialsCache;
import java.io.IOException;

public abstract class CredentialsCache {
    static CredentialsCache singleton = null;
    static String cacheName;
    private static boolean DEBUG;

    public static CredentialsCache getInstance(PrincipalName principalName) {
        return FileCredentialsCache.acquireInstance(principalName, null);
    }

    public static CredentialsCache getInstance(String string) {
        if (string.length() >= 5 && string.substring(0, 5).equalsIgnoreCase("FILE:")) {
            return FileCredentialsCache.acquireInstance(null, string.substring(5));
        }
        return FileCredentialsCache.acquireInstance(null, string);
    }

    public static CredentialsCache getInstance(PrincipalName principalName, String string) {
        if (string != null && string.length() >= 5 && string.regionMatches(true, 0, "FILE:", 0, 5)) {
            return FileCredentialsCache.acquireInstance(principalName, string.substring(5));
        }
        return FileCredentialsCache.acquireInstance(principalName, string);
    }

    public static CredentialsCache getInstance() {
        return FileCredentialsCache.acquireInstance();
    }

    public static CredentialsCache create(PrincipalName principalName, String string) {
        if (string == null) {
            throw new RuntimeException("cache name error");
        }
        if (string.length() >= 5 && string.regionMatches(true, 0, "FILE:", 0, 5)) {
            string = string.substring(5);
            return FileCredentialsCache.New(principalName, string);
        }
        return FileCredentialsCache.New(principalName, string);
    }

    public static CredentialsCache create(PrincipalName principalName) {
        return FileCredentialsCache.New(principalName);
    }

    public static String cacheName() {
        return cacheName;
    }

    public abstract PrincipalName getPrimaryPrincipal();

    public abstract void update(Credentials var1);

    public abstract void save() throws IOException, KrbException;

    public abstract Credentials[] getCredsList();

    public abstract Credentials getDefaultCreds();

    public abstract Credentials getCreds(PrincipalName var1, Realm var2);

    public abstract Credentials getCreds(LoginOptions var1, PrincipalName var2, Realm var3);

    static {
        DEBUG = Krb5.DEBUG;
    }
}

