/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal.crypto;

import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.krb5.internal.crypto.Aes256;
import ghostfucker.utils.sun.security.krb5.internal.crypto.EType;
import java.security.GeneralSecurityException;

public final class Aes256CtsHmacSha1EType
extends EType {
    public int eType() {
        return 18;
    }

    public int minimumPadSize() {
        return 0;
    }

    public int confounderSize() {
        return this.blockSize();
    }

    public int checksumType() {
        return 16;
    }

    public int checksumSize() {
        return Aes256.getChecksumLength();
    }

    public int blockSize() {
        return 16;
    }

    public int keyType() {
        return 3;
    }

    public int keySize() {
        return 32;
    }

    public byte[] encrypt(byte[] byArray, byte[] byArray2, int n) throws KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.encrypt(byArray, byArray2, byArray3, n);
    }

    public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbCryptoException {
        try {
            return Aes256.encrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2, int n) throws KrbApErrException, KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.decrypt(byArray, byArray2, byArray3, n);
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbApErrException, KrbCryptoException {
        try {
            return Aes256.decrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    public byte[] decryptedData(byte[] byArray) {
        return byArray;
    }
}

