/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal.crypto;

import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.internal.KrbApErrException;
import ghostfucker.utils.sun.security.krb5.internal.crypto.ArcFourHmac;
import ghostfucker.utils.sun.security.krb5.internal.crypto.EType;
import java.security.GeneralSecurityException;

public final class ArcFourHmacEType
extends EType {
    public int eType() {
        return 23;
    }

    public int minimumPadSize() {
        return 1;
    }

    public int confounderSize() {
        return 8;
    }

    public int checksumType() {
        return -138;
    }

    public int checksumSize() {
        return ArcFourHmac.getChecksumLength();
    }

    public int blockSize() {
        return 1;
    }

    public int keyType() {
        return 4;
    }

    public int keySize() {
        return 16;
    }

    public byte[] encrypt(byte[] byArray, byte[] byArray2, int n) throws KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.encrypt(byArray, byArray2, byArray3, n);
    }

    public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbCryptoException {
        try {
            return ArcFourHmac.encrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2, int n) throws KrbApErrException, KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.decrypt(byArray, byArray2, byArray3, n);
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbApErrException, KrbCryptoException {
        try {
            return ArcFourHmac.decrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    public byte[] decryptedData(byte[] byArray) {
        return byArray;
    }
}

