/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal.crypto;

import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.internal.crypto.CksumType;
import ghostfucker.utils.sun.security.krb5.internal.crypto.Des3;
import java.security.GeneralSecurityException;

public class HmacSha1Des3KdCksumType
extends CksumType {
    public int confounderSize() {
        return 8;
    }

    public int cksumType() {
        return 12;
    }

    public boolean isSafe() {
        return true;
    }

    public int cksumSize() {
        return 20;
    }

    public int keyType() {
        return 2;
    }

    public int keySize() {
        return 24;
    }

    public byte[] calculateChecksum(byte[] byArray, int n) {
        return null;
    }

    public byte[] calculateKeyedChecksum(byte[] byArray, int n, byte[] byArray2, int n2) throws KrbCryptoException {
        try {
            return Des3.calculateChecksum(byArray2, n2, byArray, 0, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    public boolean verifyKeyedChecksum(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) throws KrbCryptoException {
        try {
            byte[] byArray4 = Des3.calculateChecksum(byArray2, n2, byArray, 0, n);
            return HmacSha1Des3KdCksumType.isChecksumEqual(byArray3, byArray4);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }
}

