/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal.crypto;

import ghostfucker.utils.sun.security.krb5.Confounder;
import ghostfucker.utils.sun.security.krb5.KrbCryptoException;
import ghostfucker.utils.sun.security.krb5.internal.crypto.CksumType;
import ghostfucker.utils.sun.security.krb5.internal.crypto.Des;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.spec.DESKeySpec;

public final class RsaMd5DesCksumType
extends CksumType {
    public int confounderSize() {
        return 8;
    }

    public int cksumType() {
        return 8;
    }

    public boolean isSafe() {
        return true;
    }

    public int cksumSize() {
        return 24;
    }

    public int keyType() {
        return 1;
    }

    public int keySize() {
        return 8;
    }

    public byte[] calculateKeyedChecksum(byte[] byArray, int n, byte[] byArray2, int n2) throws KrbCryptoException {
        byte[] byArray3 = new byte[n + this.confounderSize()];
        byte[] byArray4 = Confounder.bytes(this.confounderSize());
        System.arraycopy(byArray4, 0, byArray3, 0, this.confounderSize());
        System.arraycopy(byArray, 0, byArray3, this.confounderSize(), n);
        byte[] byArray5 = this.calculateChecksum(byArray3, byArray3.length);
        byte[] byArray6 = new byte[this.cksumSize()];
        System.arraycopy(byArray4, 0, byArray6, 0, this.confounderSize());
        System.arraycopy(byArray5, 0, byArray6, this.confounderSize(), this.cksumSize() - this.confounderSize());
        byte[] byArray7 = new byte[this.keySize()];
        System.arraycopy(byArray2, 0, byArray7, 0, byArray2.length);
        for (int i = 0; i < byArray7.length; ++i) {
            byArray7[i] = (byte)(byArray7[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(byArray7, 0)) {
                byArray7[7] = (byte)(byArray7[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] byArray8 = new byte[byArray7.length];
        byte[] byArray9 = new byte[byArray6.length];
        Des.cbc_encrypt(byArray6, byArray9, byArray7, byArray8, true);
        return byArray9;
    }

    public boolean verifyKeyedChecksum(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) throws KrbCryptoException {
        byte[] byArray4 = this.decryptKeyedChecksum(byArray3, byArray2);
        byte[] byArray5 = new byte[n + this.confounderSize()];
        System.arraycopy(byArray4, 0, byArray5, 0, this.confounderSize());
        System.arraycopy(byArray, 0, byArray5, this.confounderSize(), n);
        byte[] byArray6 = this.calculateChecksum(byArray5, byArray5.length);
        byte[] byArray7 = new byte[this.cksumSize() - this.confounderSize()];
        System.arraycopy(byArray4, this.confounderSize(), byArray7, 0, this.cksumSize() - this.confounderSize());
        return RsaMd5DesCksumType.isChecksumEqual(byArray7, byArray6);
    }

    private byte[] decryptKeyedChecksum(byte[] byArray, byte[] byArray2) throws KrbCryptoException {
        byte[] byArray3 = new byte[this.keySize()];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray3[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(byArray3, 0)) {
                byArray3[7] = (byte)(byArray3[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] byArray4 = new byte[byArray3.length];
        byte[] byArray5 = new byte[byArray.length];
        Des.cbc_encrypt(byArray, byArray5, byArray3, byArray4, false);
        return byArray5;
    }

    public byte[] calculateChecksum(byte[] byArray, int n) throws KrbCryptoException {
        MessageDigest messageDigest;
        byte[] byArray2 = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new KrbCryptoException("JCE provider may not be installed. " + exception.getMessage());
        }
        try {
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new KrbCryptoException(exception.getMessage());
        }
        return byArray2;
    }
}

