/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.krb5.internal.ktab;

import ghostfucker.utils.sun.security.krb5.internal.ktab.KeyTabConstants;
import ghostfucker.utils.sun.security.krb5.internal.ktab.KeyTabEntry;
import ghostfucker.utils.sun.security.krb5.internal.util.KrbDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class KeyTabOutputStream
extends KrbDataOutputStream
implements KeyTabConstants {
    private KeyTabEntry entry;
    private int keyType;
    private byte[] keyValue;
    public int version;

    public KeyTabOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeVersion(int n) throws IOException {
        this.version = n;
        this.write16(n);
    }

    public void writeEntry(KeyTabEntry keyTabEntry) throws IOException {
        this.write32(keyTabEntry.entryLength());
        String[] stringArray = keyTabEntry.service.getNameStrings();
        int n = stringArray.length;
        if (this.version == 1281) {
            this.write16(n + 1);
        } else {
            this.write16(n);
        }
        byte[] byArray = null;
        try {
            byArray = keyTabEntry.service.getRealmString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.write16(byArray.length);
        this.write(byArray);
        for (int i = 0; i < n; ++i) {
            try {
                this.write16(stringArray[i].getBytes("8859_1").length);
                this.write(stringArray[i].getBytes("8859_1"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.write32(keyTabEntry.service.getNameType());
        this.write32((int)(keyTabEntry.timestamp.getTime() / 1000L));
        this.write8(keyTabEntry.keyVersion % 256);
        this.write16(keyTabEntry.keyType);
        this.write16(keyTabEntry.keyblock.length);
        this.write(keyTabEntry.keyblock);
    }
}

