/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.pkcs;

import ghostfucker.utils.sun.misc.BASE64Encoder;
import ghostfucker.utils.sun.security.pkcs.PKCS10Attributes;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.x509.AlgorithmId;
import ghostfucker.utils.sun.security.x509.X500Name;
import ghostfucker.utils.sun.security.x509.X500Signer;
import ghostfucker.utils.sun.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Arrays;

public class PKCS10 {
    private X500Name subject;
    private PublicKey subjectPublicKeyInfo;
    private PKCS10Attributes attributeSet;
    private byte[] encoded;

    public PKCS10(PublicKey publicKey) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = new PKCS10Attributes();
    }

    public PKCS10(PublicKey publicKey, PKCS10Attributes pKCS10Attributes) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = pKCS10Attributes;
    }

    public PKCS10(byte[] byArray) throws IOException, SignatureException, NoSuchAlgorithmException {
        this.encoded = byArray;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        if (derValueArray.length != 3) {
            throw new IllegalArgumentException("not a PKCS #10 request");
        }
        byArray = derValueArray[0].toByteArray();
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[1]);
        byte[] byArray2 = derValueArray[2].getBitString();
        BigInteger bigInteger = derValueArray[0].data.getBigInteger();
        if (!bigInteger.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("not PKCS #10 v1");
        }
        this.subject = new X500Name(derValueArray[0].data);
        this.subjectPublicKeyInfo = X509Key.parse(derValueArray[0].data.getDerValue());
        this.attributeSet = derValueArray[0].data.available() != 0 ? new PKCS10Attributes(derValueArray[0].data) : new PKCS10Attributes();
        if (derValueArray[0].data.available() != 0) {
            throw new IllegalArgumentException("illegal PKCS #10 data");
        }
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(this.subjectPublicKeyInfo);
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new SignatureException("Invalid PKCS #10 signature");
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException("invalid key");
        }
    }

    public void encodeAndSign(X500Signer x500Signer) throws CertificateException, IOException, SignatureException {
        if (this.encoded != null) {
            throw new SignatureException("request is already signed");
        }
        this.subject = x500Signer.getSigner();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.ZERO);
        this.subject.encode(derOutputStream);
        derOutputStream.write(this.subjectPublicKeyInfo.getEncoded());
        this.attributeSet.encode(derOutputStream);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        byte[] byArray = derOutputStream2.toByteArray();
        derOutputStream = derOutputStream2;
        x500Signer.update(byArray, 0, byArray.length);
        byte[] byArray2 = x500Signer.sign();
        x500Signer.getAlgorithmId().encode(derOutputStream);
        derOutputStream.putBitString(byArray2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        this.encoded = derOutputStream2.toByteArray();
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public PublicKey getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public PKCS10Attributes getAttributes() {
        return this.attributeSet;
    }

    public byte[] getEncoded() {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        return null;
    }

    public void print(PrintStream printStream) throws IOException, SignatureException {
        if (this.encoded == null) {
            throw new SignatureException("Cert request was not signed");
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        printStream.println("-----BEGIN NEW CERTIFICATE REQUEST-----");
        bASE64Encoder.encodeBuffer(this.encoded, (OutputStream)printStream);
        printStream.println("-----END NEW CERTIFICATE REQUEST-----");
    }

    public String toString() {
        return "[PKCS #10 certificate request:\n" + this.subjectPublicKeyInfo.toString() + " subject: <" + this.subject + ">" + "\n" + " attributes: " + this.attributeSet.toString() + "\n]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS10)) {
            return false;
        }
        if (this.encoded == null) {
            return false;
        }
        byte[] byArray = ((PKCS10)object).getEncoded();
        if (byArray == null) {
            return false;
        }
        return Arrays.equals(this.encoded, byArray);
    }

    public int hashCode() {
        int n = 0;
        if (this.encoded != null) {
            for (int i = 1; i < this.encoded.length; ++i) {
                n += this.encoded[i] * i;
            }
        }
        return n;
    }
}

