/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class ByteBufferInputStream
extends InputStream {
    ByteBuffer bb;

    ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.bb = byteBuffer;
    }

    public int read() throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (this.bb.remaining() == 0) {
            return -1;
        }
        return this.bb.get();
    }

    public int read(byte[] byArray) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = Math.min(this.bb.remaining(), n2);
        if (n3 == 0) {
            return -1;
        }
        this.bb.get(byArray, n, n3);
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.bb == null) {
            throw new IOException("skip on a closed InputStream");
        }
        if (l <= 0L) {
            return 0L;
        }
        int n = (int)l;
        int n2 = Math.min(this.bb.remaining(), n);
        this.bb.position(this.bb.position() + n2);
        return n;
    }

    public int available() throws IOException {
        if (this.bb == null) {
            throw new IOException("available on a closed InputStream");
        }
        return this.bb.remaining();
    }

    public void close() throws IOException {
        this.bb = null;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

