/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.misc.CharacterEncoder;
import ghostfucker.utils.sun.misc.HexDumpEncoder;
import ghostfucker.utils.sun.security.ssl.CipherSuite;
import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.JsseJce;
import ghostfucker.utils.sun.security.ssl.ProtocolVersion;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

final class CipherBox {
    static final CipherBox NULL = new CipherBox();
    private static final Debug debug = Debug.getInstance("ssl");
    private final ProtocolVersion protocolVersion;
    private final Cipher cipher;
    private int blockSize;

    private CipherBox() {
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.cipher = null;
    }

    private CipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, boolean bl) throws NoSuchAlgorithmException {
        try {
            this.protocolVersion = protocolVersion;
            this.cipher = JsseJce.getCipher(bulkCipher.transformation);
            int n = bl ? 1 : 2;
            this.cipher.init(n, (Key)secretKey, ivParameterSpec);
            this.blockSize = this.cipher.getBlockSize();
            if (this.blockSize == 1) {
                this.blockSize = 0;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exceptionInInitializerError);
        }
    }

    static CipherBox newCipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, boolean bl) throws NoSuchAlgorithmException {
        if (!bulkCipher.allowed) {
            throw new NoSuchAlgorithmException("Unsupported cipher " + bulkCipher);
        }
        if (bulkCipher == CipherSuite.B_NULL) {
            return NULL;
        }
        return new CipherBox(protocolVersion, bulkCipher, secretKey, ivParameterSpec, bl);
    }

    int encrypt(byte[] byArray, int n, int n2) {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n3;
            if (this.blockSize != 0) {
                n2 = CipherBox.addPadding(byArray, n, n2, this.blockSize);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + n2);
                    hexDumpEncoder.encodeBuffer(new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((n3 = this.cipher.update(byArray, n, n2, byArray, n)) != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int encrypt(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n;
        }
        try {
            Object object;
            int n2 = byteBuffer.position();
            if (this.blockSize != 0) {
                n = CipherBox.addPadding(byteBuffer, this.blockSize);
                byteBuffer.position(n2);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    object = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + n);
                    ((CharacterEncoder)object).encodeBuffer(byteBuffer, (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byteBuffer.position(n2);
            }
            object = byteBuffer.duplicate();
            int n3 = this.cipher.update((ByteBuffer)object, byteBuffer);
            if (byteBuffer.position() != ((Buffer)object).position()) {
                throw new RuntimeException("bytebuffer padding error");
            }
            if (n3 != n) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            RuntimeException runtimeException = new RuntimeException(shortBufferException.toString());
            runtimeException.initCause(shortBufferException);
            throw runtimeException;
        }
    }

    int decrypt(byte[] byArray, int n, int n2) throws BadPaddingException {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n3 = this.cipher.update(byArray, n, n2, byArray, n);
            if (n3 != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n3);
                    hexDumpEncoder.encodeBuffer(new ByteArrayInputStream(byArray, n, n3), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                n3 = CipherBox.removePadding(byArray, n, n3, this.blockSize, this.protocolVersion);
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int decrypt(ByteBuffer byteBuffer) throws BadPaddingException {
        int n = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n;
        }
        try {
            int n2 = byteBuffer.position();
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            int n3 = this.cipher.update(byteBuffer2, byteBuffer);
            if (n3 != n) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                byteBuffer.position(n2);
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n3);
                    hexDumpEncoder.encodeBuffer(byteBuffer, (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                byteBuffer.position(n2);
                n3 = CipherBox.removePadding(byteBuffer, this.blockSize, this.protocolVersion);
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            RuntimeException runtimeException = new RuntimeException(shortBufferException.toString());
            runtimeException.initCause(shortBufferException);
            throw runtimeException;
        }
    }

    private static int addPadding(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 + 1;
        if (n4 % n3 != 0) {
            n4 += n3 - 1;
            n4 -= n4 % n3;
        }
        int n5 = n4 - n2;
        if (byArray.length < n4 + n) {
            throw new IllegalArgumentException("no space to pad buffer");
        }
        n += n2;
        for (int i = 0; i < n5; ++i) {
            byArray[n++] = (byte)(n5 - 1);
        }
        return n4;
    }

    private static int addPadding(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer.position();
        int n4 = n2 + 1;
        if (n4 % n != 0) {
            n4 += n - 1;
            n4 -= n4 % n;
        }
        int n5 = n4 - n2;
        byteBuffer.limit(n4 + n3);
        n3 += n2;
        for (int i = 0; i < n5; ++i) {
            byteBuffer.put(n3++, (byte)(n5 - 1));
        }
        byteBuffer.position(n3);
        byteBuffer.limit(n3);
        return n4;
    }

    private static int removePadding(byte[] byArray, int n, int n2, int n3, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n4 = n + n2 - 1;
        int n5 = byArray[n4] & 0xFF;
        int n6 = n2 - (n5 + 1);
        if (n6 < 0) {
            throw new BadPaddingException("Padding length invalid: " + n5);
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            for (int i = 1; i <= n5; ++i) {
                int n7 = byArray[n4 - i] & 0xFF;
                if (n7 == n5) continue;
                throw new BadPaddingException("Invalid TLS padding: " + n7);
            }
        } else if (n5 > n3) {
            throw new BadPaddingException("Invalid SSLv3 padding: " + n5);
        }
        return n6;
    }

    private static int removePadding(ByteBuffer byteBuffer, int n, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n2;
        int n3;
        int n4;
        int n5 = byteBuffer.remaining();
        int n6 = n5 - ((n4 = byteBuffer.get(n3 = (n2 = byteBuffer.position()) + n5 - 1) & 0xFF) + 1);
        if (n6 < 0) {
            throw new BadPaddingException("Padding length invalid: " + n4);
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            byteBuffer.put(n3, (byte)0);
            for (int i = 1; i <= n4; ++i) {
                int n7 = byteBuffer.get(n3 - i) & 0xFF;
                if (n7 == n4) continue;
                throw new BadPaddingException("Invalid TLS padding: " + n7);
            }
        } else if (n4 > n) {
            throw new BadPaddingException("Invalid SSLv3 padding: " + n4);
        }
        byteBuffer.position(n2 + n6);
        byteBuffer.limit(n2 + n6);
        return n6;
    }
}

