/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.HandshakeInStream;
import ghostfucker.utils.sun.security.ssl.HandshakeMessage;
import ghostfucker.utils.sun.security.ssl.HandshakeOutStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;

final class DHClientKeyExchange
extends HandshakeMessage {
    private byte[] dh_Yc;

    int messageType() {
        return 16;
    }

    BigInteger getClientPublicKey() {
        return new BigInteger(1, this.dh_Yc);
    }

    DHClientKeyExchange(BigInteger bigInteger) {
        this.dh_Yc = DHClientKeyExchange.toByteArray(bigInteger);
    }

    DHClientKeyExchange() {
        this.dh_Yc = null;
    }

    DHClientKeyExchange(HandshakeInStream handshakeInStream) throws IOException {
        this.dh_Yc = handshakeInStream.getBytes16();
    }

    int messageLength() {
        if (this.dh_Yc == null) {
            return 0;
        }
        return this.dh_Yc.length + 2;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putBytes16(this.dh_Yc);
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, DH");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(printStream, "DH Public key", this.dh_Yc);
        }
    }
}

