/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.HandshakeInStream;
import ghostfucker.utils.sun.security.ssl.HandshakeMessage;
import ghostfucker.utils.sun.security.ssl.HandshakeOutStream;
import ghostfucker.utils.sun.security.ssl.JsseJce;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

final class ECDHClientKeyExchange
extends HandshakeMessage {
    private byte[] encodedPoint;

    int messageType() {
        return 16;
    }

    byte[] getEncodedPoint() {
        return this.encodedPoint;
    }

    ECDHClientKeyExchange(PublicKey publicKey) {
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        ECPoint eCPoint = eCPublicKey.getW();
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        this.encodedPoint = JsseJce.encodePoint(eCPoint, eCParameterSpec.getCurve());
    }

    ECDHClientKeyExchange(HandshakeInStream handshakeInStream) throws IOException {
        this.encodedPoint = handshakeInStream.getBytes8();
    }

    int messageLength() {
        return this.encodedPoint.length + 1;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putBytes8(this.encodedPoint);
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ECDHClientKeyExchange");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(printStream, "ECDH Public value", this.encodedPoint);
        }
    }
}

