/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.ssl.CipherBox;
import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.EngineArgs;
import ghostfucker.utils.sun.security.ssl.EngineWriter;
import ghostfucker.utils.sun.security.ssl.InputRecord;
import ghostfucker.utils.sun.security.ssl.MAC;
import ghostfucker.utils.sun.security.ssl.OutputRecord;
import ghostfucker.utils.sun.security.ssl.SSLEngineImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class EngineOutputRecord
extends OutputRecord {
    private EngineWriter writer;
    private boolean finishedMsg = false;

    EngineOutputRecord(byte by, SSLEngineImpl sSLEngineImpl) {
        super(by, EngineOutputRecord.recordSize(by));
        this.writer = sSLEngineImpl.writer;
    }

    private static int recordSize(byte by) {
        switch (by) {
            case 20: 
            case 21: {
                return 283;
            }
            case 22: {
                return 16665;
            }
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Unknown record type: " + by);
    }

    void setFinishedMsg() {
        this.finishedMsg = true;
    }

    public void flush() throws IOException {
        this.finishedMsg = false;
    }

    boolean isFinishedMsg() {
        return this.finishedMsg;
    }

    private void addMAC(MAC mAC, ByteBuffer byteBuffer) throws IOException {
        if (mAC.MAClen() != 0) {
            byte[] byArray = mAC.compute(this.contentType(), byteBuffer);
            byteBuffer.limit(byteBuffer.limit() + byArray.length);
            byteBuffer.put(byArray);
        }
    }

    void encrypt(CipherBox cipherBox, ByteBuffer byteBuffer) {
        cipherBox.encrypt(byteBuffer);
    }

    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(n2).put(byArray, 0, n2).flip();
        this.writer.putOutboundData(byteBuffer);
    }

    void write(MAC mAC, CipherBox cipherBox) throws IOException {
        switch (this.contentType()) {
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected byte buffers");
            }
        }
        if (!this.isEmpty()) {
            this.addMAC(mAC);
            this.encrypt(cipherBox);
            this.write((OutputStream)null);
        }
    }

    void write(EngineArgs engineArgs, MAC mAC, CipherBox cipherBox) throws IOException {
        assert (this.contentType() == 23);
        if (mAC == MAC.NULL) {
            return;
        }
        int n = Math.min(engineArgs.getAppRemaining(), 16384);
        if (n == 0) {
            return;
        }
        ByteBuffer byteBuffer = engineArgs.netData;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = n2 + 5;
        byteBuffer.position(n4);
        engineArgs.gather(n);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n4);
        this.addMAC(mAC, byteBuffer);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n4);
        this.encrypt(cipherBox, byteBuffer);
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake")) && (debug != null && Debug.isOn("record") || this.contentType() == 20)) {
            System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + n);
        }
        int n5 = byteBuffer.limit() - n4;
        byteBuffer.put(n2, this.contentType());
        byteBuffer.put(n2 + 1, this.protocolVersion.major);
        byteBuffer.put(n2 + 2, this.protocolVersion.minor);
        byteBuffer.put(n2 + 3, (byte)(n5 >> 8));
        byteBuffer.put(n2 + 4, (byte)n5);
        byteBuffer.limit(n3);
    }
}

