/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.ssl.CloneableDigest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class HandshakeHash {
    private final MessageDigest md5;
    private final MessageDigest sha;

    HandshakeHash(boolean bl) {
        int n = bl ? 3 : 2;
        try {
            this.md5 = CloneableDigest.getDigest("MD5", n);
            this.sha = CloneableDigest.getDigest("SHA", n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Algorithm MD5 or SHA not available", noSuchAlgorithmException);
        }
    }

    void update(byte by) {
        this.md5.update(by);
        this.sha.update(by);
    }

    void update(byte[] byArray, int n, int n2) {
        this.md5.update(byArray, n, n2);
        this.sha.update(byArray, n, n2);
    }

    void reset() {
        this.md5.reset();
        this.sha.reset();
    }

    MessageDigest getMD5Clone() {
        return HandshakeHash.cloneDigest(this.md5);
    }

    MessageDigest getSHAClone() {
        return HandshakeHash.cloneDigest(this.sha);
    }

    private static MessageDigest cloneDigest(MessageDigest messageDigest) {
        try {
            return (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Could not clone digest", cloneNotSupportedException);
        }
    }
}

