/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.ssl.SunJSSE;
import ghostfucker.utils.sun.security.ssl.SunX509KeyManagerImpl;
import ghostfucker.utils.sun.security.ssl.X509KeyManagerImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;

abstract class KeyManagerFactoryImpl
extends KeyManagerFactorySpi {
    X509ExtendedKeyManager keyManager;
    boolean isInitialized;

    KeyManagerFactoryImpl() {
    }

    protected KeyManager[] engineGetKeyManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("KeyManagerFactoryImpl is not initialized");
        }
        return new KeyManager[]{this.keyManager};
    }

    public static final class X509
    extends KeyManagerFactoryImpl {
        protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (keyStore == null) {
                this.keyManager = new X509KeyManagerImpl(Collections.<KeyStore.Builder>emptyList());
            } else {
                if (SunJSSE.isFIPS() && keyStore.getProvider() != SunJSSE.cryptoProvider) {
                    throw new KeyStoreException("FIPS mode: KeyStore must be from provider " + SunJSSE.cryptoProvider.getName());
                }
                try {
                    KeyStore.Builder builder = KeyStore.Builder.newInstance(keyStore, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(cArray));
                    this.keyManager = new X509KeyManagerImpl(builder);
                }
                catch (RuntimeException runtimeException) {
                    throw new KeyStoreException("initialization failed", runtimeException);
                }
            }
            this.isInitialized = true;
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            if (!(managerFactoryParameters instanceof KeyStoreBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
            }
            if (SunJSSE.isFIPS()) {
                throw new InvalidAlgorithmParameterException("FIPS mode: KeyStoreBuilderParameters not supported");
            }
            List<KeyStore.Builder> list = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
            this.keyManager = new X509KeyManagerImpl(list);
            this.isInitialized = true;
        }
    }

    public static final class SunX509
    extends KeyManagerFactoryImpl {
        protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (keyStore != null && SunJSSE.isFIPS() && keyStore.getProvider() != SunJSSE.cryptoProvider) {
                throw new KeyStoreException("FIPS mode: KeyStore must be from provider " + SunJSSE.cryptoProvider.getName());
            }
            this.keyManager = new SunX509KeyManagerImpl(keyStore, cArray);
            this.isInitialized = true;
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("SunX509KeyManager does not use ManagerFactoryParameters");
        }
    }
}

