/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.misc.HexDumpEncoder;
import ghostfucker.utils.sun.security.ssl.CipherBox;
import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.HandshakeHash;
import ghostfucker.utils.sun.security.ssl.InputRecord;
import ghostfucker.utils.sun.security.ssl.MAC;
import ghostfucker.utils.sun.security.ssl.ProtocolVersion;
import ghostfucker.utils.sun.security.ssl.Record;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLException;

class OutputRecord
extends ByteArrayOutputStream
implements Record {
    private HandshakeHash handshakeHash;
    private int lastHashed;
    private boolean firstMessage = true;
    private final byte contentType;
    ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private ProtocolVersion helloVersion = ProtocolVersion.DEFAULT_HELLO;
    static final Debug debug = Debug.getInstance("ssl");
    private static int[] V3toV2CipherMap1 = new int[]{-1, -1, -1, 2, 1, -1, 4, 5, -1, 6, 7};
    private static int[] V3toV2CipherMap3 = new int[]{-1, -1, -1, 128, 128, -1, 128, 128, -1, 64, 192};

    OutputRecord(byte by, int n) {
        super(n);
        this.count = 5;
        this.contentType = by;
        this.lastHashed = this.count;
    }

    OutputRecord(byte by) {
        this(by, OutputRecord.recordSize(by));
    }

    private static int recordSize(byte by) {
        if (by == 20 || by == 21) {
            return 283;
        }
        return 16665;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    synchronized void setHelloVersion(ProtocolVersion protocolVersion) {
        this.helloVersion = protocolVersion;
    }

    public synchronized void reset() {
        super.reset();
        this.lastHashed = this.count = 5;
    }

    void setHandshakeHash(HandshakeHash handshakeHash) {
        assert (this.contentType == 22);
        this.handshakeHash = handshakeHash;
    }

    void doHashes() {
        int n = this.count - this.lastHashed;
        if (n > 0) {
            this.hashInternal(this.buf, this.lastHashed, n);
            this.lastHashed = this.count;
        }
    }

    private void hashInternal(byte[] byArray, int n, int n2) {
        if (debug != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[write] MD5 and SHA1 hashes:  len = " + n2);
                hexDumpEncoder.encodeBuffer(new ByteArrayInputStream(byArray, this.lastHashed, n2), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.handshakeHash.update(byArray, this.lastHashed, n2);
        this.lastHashed = this.count;
    }

    boolean isEmpty() {
        return this.count == 5;
    }

    boolean isAlert(byte by) {
        if (this.count > 6 && this.contentType == 21) {
            return this.buf[6] == by;
        }
        return false;
    }

    void addMAC(MAC mAC) throws IOException {
        if (this.contentType == 22) {
            this.doHashes();
        }
        if (mAC.MAClen() != 0) {
            byte[] byArray = mAC.compute(this.contentType, this.buf, 5, this.count - 5);
            this.write(byArray);
        }
    }

    void encrypt(CipherBox cipherBox) {
        int n = this.count - 5;
        this.count = 5 + cipherBox.encrypt(this.buf, 5, n);
    }

    final int availableDataBytes() {
        int n = this.count - 5;
        return 16384 - n;
    }

    final byte contentType() {
        return this.contentType;
    }

    void write(OutputStream outputStream) throws IOException {
        if (this.count == 5) {
            return;
        }
        int n = this.count - 5;
        if (n < 0) {
            throw new SSLException("output record size too small: " + n);
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake")) && (debug != null && Debug.isOn("record") || this.contentType() == 20)) {
            System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + n);
        }
        if (this.firstMessage && this.useV2Hello()) {
            byte[] byArray = new byte[n - 4];
            System.arraycopy(this.buf, 9, byArray, 0, byArray.length);
            this.V3toV2ClientHello(byArray);
            this.handshakeHash.reset();
            this.lastHashed = 2;
            this.doHashes();
            if (debug != null && Debug.isOn("record")) {
                System.out.println(Thread.currentThread().getName() + ", WRITE: SSLv2 client hello message" + ", length = " + (this.count - 2));
            }
        } else {
            this.buf[0] = this.contentType;
            this.buf[1] = this.protocolVersion.major;
            this.buf[2] = this.protocolVersion.minor;
            this.buf[3] = (byte)(n >> 8);
            this.buf[4] = (byte)n;
        }
        this.firstMessage = false;
        this.writeBuffer(outputStream, this.buf, 0, this.count);
        this.reset();
    }

    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(byArray, n, n2);
        outputStream.flush();
        if (debug != null && Debug.isOn("packet")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
                System.out.println("[Raw write]: length = " + byteBuffer.remaining());
                hexDumpEncoder.encodeBuffer(byteBuffer, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean useV2Hello() {
        return this.firstMessage && this.helloVersion == ProtocolVersion.SSL20Hello && this.contentType == 22 && this.buf[5] == 1 && this.buf[43] == 0;
    }

    private void V3toV2ClientHello(byte[] byArray) throws SSLException {
        int n = 34;
        byte by = byArray[n];
        int n2 = n + 1 + by;
        int n3 = ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
        int n4 = n3 / 2;
        int n5 = n2 + 2;
        int n6 = 0;
        this.count = 11;
        for (int i = 0; i < n4; ++i) {
            byte by2 = byArray[n5++];
            byte by3 = byArray[n5++];
            n6 += this.V3toV2CipherSuite(by2, by3);
        }
        this.buf[2] = 1;
        this.buf[3] = byArray[0];
        this.buf[4] = byArray[1];
        this.buf[5] = (byte)(n6 >>> 8);
        this.buf[6] = (byte)n6;
        this.buf[7] = 0;
        this.buf[8] = 0;
        this.buf[9] = 0;
        this.buf[10] = 32;
        System.arraycopy(byArray, 2, this.buf, this.count, 32);
        this.count += 32;
        this.count -= 2;
        this.buf[0] = (byte)(this.count >>> 8);
        this.buf[0] = (byte)(this.buf[0] | 0x80);
        this.buf[1] = (byte)this.count;
        this.count += 2;
    }

    private int V3toV2CipherSuite(byte by, byte by2) {
        this.buf[this.count++] = 0;
        this.buf[this.count++] = by;
        this.buf[this.count++] = by2;
        if ((by2 & 0xFF) > 10 || V3toV2CipherMap1[by2] == -1) {
            return 3;
        }
        this.buf[this.count++] = (byte)V3toV2CipherMap1[by2];
        this.buf[this.count++] = 0;
        this.buf[this.count++] = (byte)V3toV2CipherMap3[by2];
        return 6;
    }
}

