/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.ssl.ProtocolVersion;
import ghostfucker.utils.sun.security.ssl.SunJSSE;
import java.util.ArrayList;
import java.util.Collection;

final class ProtocolList {
    private static final ProtocolList SUPPORTED = SunJSSE.isFIPS() ? new ProtocolList(new String[]{ProtocolVersion.TLS10.name}) : new ProtocolList(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name});
    private final Collection<ProtocolVersion> protocols;
    private String[] protocolNames;
    final ProtocolVersion min;
    final ProtocolVersion max;
    final ProtocolVersion helloVersion;

    ProtocolList(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Protocols may not be null");
        }
        this.protocols = new ArrayList<ProtocolVersion>(3);
        for (int i = 0; i < stringArray.length; ++i) {
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(stringArray[i]);
            if (this.protocols.contains(protocolVersion)) continue;
            this.protocols.add(protocolVersion);
        }
        if (this.protocols.size() == 1 && this.protocols.contains(ProtocolVersion.SSL20Hello)) {
            throw new IllegalArgumentException("SSLv2Hellocannot be enabled unless TLSv1 or SSLv3 is also enabled");
        }
        this.min = this.contains(ProtocolVersion.SSL30) ? ProtocolVersion.SSL30 : ProtocolVersion.TLS10;
        this.max = this.contains(ProtocolVersion.TLS10) ? ProtocolVersion.TLS10 : ProtocolVersion.SSL30;
        this.helloVersion = this.protocols.contains(ProtocolVersion.SSL20Hello) ? ProtocolVersion.SSL20Hello : this.min;
    }

    boolean contains(ProtocolVersion protocolVersion) {
        if (protocolVersion == ProtocolVersion.SSL20Hello) {
            return false;
        }
        return this.protocols.contains(protocolVersion);
    }

    synchronized String[] toStringArray() {
        if (this.protocolNames == null) {
            this.protocolNames = new String[this.protocols.size()];
            int n = 0;
            for (ProtocolVersion protocolVersion : this.protocols) {
                this.protocolNames[n++] = protocolVersion.name;
            }
        }
        return (String[])this.protocolNames.clone();
    }

    public String toString() {
        return this.protocols.toString();
    }

    static ProtocolList getDefault() {
        return SUPPORTED;
    }

    static ProtocolList getSupported() {
        return SUPPORTED;
    }
}

