/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.HandshakeInStream;
import ghostfucker.utils.sun.security.ssl.HandshakeMessage;
import ghostfucker.utils.sun.security.ssl.HandshakeOutStream;
import ghostfucker.utils.sun.security.ssl.JsseJce;
import ghostfucker.utils.sun.security.ssl.ProtocolVersion;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;

final class RSAClientKeyExchange
extends HandshakeMessage {
    private static final String PROP_NAME = "com.sun.net.ssl.rsaPreMasterSecretFix";
    private static final boolean rsaPreMasterSecretFix = Debug.getBooleanProperty("com.sun.net.ssl.rsaPreMasterSecretFix", false);
    private ProtocolVersion protocolVersion;
    SecretKey preMaster;
    private byte[] encrypted;

    int messageType() {
        return 16;
    }

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, PublicKey publicKey) throws IOException {
        byte by;
        byte by2;
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        if (rsaPreMasterSecretFix) {
            by2 = protocolVersion2.major;
            by = protocolVersion2.minor;
        } else {
            by2 = protocolVersion.major;
            by = protocolVersion.minor;
        }
        try {
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator("SunTlsRsaPremasterSecret");
            keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(by2, by));
            this.preMaster = keyGenerator.generateKey();
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, secureRandom);
            this.encrypted = cipher.wrap(this.preMaster);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(generalSecurityException);
        }
    }

    RSAClientKeyExchange(ProtocolVersion protocolVersion, HandshakeInStream handshakeInStream, int n, PrivateKey privateKey) throws IOException {
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Private key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.encrypted = handshakeInStream.getBytes16();
        } else {
            this.encrypted = new byte[n];
            if (handshakeInStream.read(this.encrypted) != n) {
                throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
            }
        }
        try {
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(4, privateKey);
            this.preMaster = (SecretKey)cipher.unwrap(this.encrypted, "TlsRsaPremasterSecret", 3);
        }
        catch (Exception exception) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Error decrypting premaster secret:");
                exception.printStackTrace(System.out);
                System.out.println("Generating random secret");
            }
            this.preMaster = RSAClientKeyExchange.generateDummySecret(protocolVersion);
        }
    }

    static SecretKey generateDummySecret(ProtocolVersion protocolVersion) {
        try {
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator("SunTlsRsaPremasterSecret");
            keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(protocolVersion.major, protocolVersion.minor));
            return keyGenerator.generateKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate dummy secret", generalSecurityException);
        }
    }

    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            handshakeOutStream.putBytes16(this.encrypted);
        } else {
            handshakeOutStream.write(this.encrypted);
        }
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, RSA PreMasterSecret, " + this.protocolVersion);
    }
}

