/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.misc.Cache;
import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.SSLSessionImpl;
import ghostfucker.utils.sun.security.ssl.SessionId;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SSLSessionContextImpl
implements SSLSessionContext {
    private Cache sessionCache = new Cache();
    private Cache sessionHostPortCache = new Cache();
    private int cacheLimit = this.getCacheLimit();
    private long timeoutMillis = 86400000L;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLSessionContextImpl() {
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        SSLSession sSLSession = (SSLSession)this.sessionCache.get(new SessionId(byArray));
        return this.checkTimeValidity(sSLSession);
    }

    @Override
    public Enumeration<byte[]> getIds() {
        Vector<byte[]> vector = new Vector<byte[]>(this.sessionCache.size());
        Enumeration enumeration = this.sessionCache.keys();
        while (enumeration.hasMoreElements()) {
            SessionId sessionId = (SessionId)enumeration.nextElement();
            if (this.isTimedout((SSLSession)this.sessionCache.get(sessionId))) continue;
            vector.addElement(sessionId.getId());
        }
        return vector.elements();
    }

    @Override
    public void setSessionTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.timeoutMillis = (long)n * 1000L;
    }

    @Override
    public int getSessionTimeout() {
        return (int)(this.timeoutMillis / 1000L);
    }

    @Override
    public void setSessionCacheSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.cacheLimit = n;
        if (this.cacheLimit != 0 && this.sessionCache.size() > this.cacheLimit) {
            this.adjustCacheSizeTo(this.cacheLimit);
        }
    }

    @Override
    public int getSessionCacheSize() {
        return this.cacheLimit;
    }

    SSLSessionImpl get(byte[] byArray) {
        return (SSLSessionImpl)this.getSession(byArray);
    }

    SSLSessionImpl get(String string, int n) {
        if (string == null && n == -1) {
            return null;
        }
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)this.sessionHostPortCache.get(this.getKey(string, n));
        return (SSLSessionImpl)this.checkTimeValidity(sSLSessionImpl);
    }

    private String getKey(String string, int n) {
        return (string + ":" + String.valueOf(n)).toLowerCase();
    }

    void put(SSLSessionImpl sSLSessionImpl) {
        if (this.cacheLimit != 0 && this.sessionCache.size() >= this.cacheLimit) {
            this.adjustCacheSizeTo(this.cacheLimit - 1);
        }
        this.sessionCache.put(sSLSessionImpl.getSessionId(), sSLSessionImpl);
        if (sSLSessionImpl.getPeerHost() != null && sSLSessionImpl.getPeerPort() != -1) {
            this.sessionHostPortCache.put(this.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()), sSLSessionImpl);
        }
        sSLSessionImpl.setContext(this);
    }

    private void adjustCacheSizeTo(int n) {
        int n2 = this.sessionCache.size();
        if (n < 0) {
            return;
        }
        while (n2 > n) {
            SSLSessionImpl sSLSessionImpl = null;
            SSLSessionImpl sSLSessionImpl2 = null;
            if (debug != null && Debug.isOn("sessioncache")) {
                System.out.println("exceeded cache limit of " + this.cacheLimit);
            }
            int n3 = 0;
            Enumeration enumeration = this.sessionCache.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    sSLSessionImpl2 = (SSLSessionImpl)enumeration.nextElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                if (this.isTimedout(sSLSessionImpl2)) {
                    sSLSessionImpl = sSLSessionImpl2;
                    break;
                }
                if (sSLSessionImpl == null || sSLSessionImpl2.getLastAccessedTime() < sSLSessionImpl.getLastAccessedTime()) {
                    sSLSessionImpl = sSLSessionImpl2;
                }
                ++n3;
            }
            if (sSLSessionImpl != null && n3 > n) {
                if (debug != null && Debug.isOn("sessioncache")) {
                    System.out.println("uncaching " + sSLSessionImpl);
                }
                sSLSessionImpl.invalidate();
            }
            n2 = --n3;
        }
    }

    void remove(SessionId sessionId) {
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)this.sessionCache.get(sessionId);
        this.sessionCache.remove(sessionId);
        this.sessionHostPortCache.remove(this.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()));
    }

    private int getCacheLimit() {
        int n = 0;
        try {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("javax.net.ssl.sessionCacheSize");
                }
            });
            n = string != null ? Integer.valueOf(string) : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n > 0 ? n : 0;
    }

    SSLSession checkTimeValidity(SSLSession sSLSession) {
        if (this.isTimedout(sSLSession)) {
            sSLSession.invalidate();
            return null;
        }
        return sSLSession;
    }

    boolean isTimedout(SSLSession sSLSession) {
        if (this.timeoutMillis == 0L) {
            return false;
        }
        return sSLSession != null && sSLSession.getCreationTime() + this.timeoutMillis <= System.currentTimeMillis();
    }
}

