/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ssl;

import ghostfucker.utils.sun.security.ssl.Debug;
import ghostfucker.utils.sun.security.ssl.X509TrustManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXBuilderParameters;
import java.util.HashMap;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

abstract class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private X509TrustManager trustManager = null;
    private boolean isInitialized = false;

    TrustManagerFactoryImpl() {
    }

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            try {
                keyStore = TrustManagerFactoryImpl.getCacertsKeyStore("trustmanager");
            }
            catch (SecurityException securityException) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + securityException);
                }
            }
            catch (Error error) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + error);
                }
                throw error;
            }
            catch (RuntimeException runtimeException) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + runtimeException);
                }
                throw runtimeException;
            }
            catch (Exception exception) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + exception);
                }
                throw new KeyStoreException("problem accessing trust store" + exception);
            }
        }
        this.trustManager = this.getInstance(keyStore);
        this.isInitialized = true;
    }

    abstract X509TrustManager getInstance(KeyStore var1) throws KeyStoreException;

    abstract X509TrustManager getInstance(ManagerFactoryParameters var1) throws InvalidAlgorithmParameterException;

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.trustManager = this.getInstance(managerFactoryParameters);
        this.isInitialized = true;
    }

    protected TrustManager[] engineGetTrustManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.trustManager};
    }

    private static FileInputStream getFileInputStream(final File file) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    if (file.exists()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        });
    }

    static KeyStore getCacertsKeyStore(String string) throws Exception {
        Object object;
        String string2 = null;
        File file = null;
        FileInputStream fileInputStream = null;
        final HashMap hashMap = new HashMap();
        String string3 = File.separator;
        KeyStore keyStore = null;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                hashMap.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                hashMap.put("javaHome", System.getProperty("java.home"));
                hashMap.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                hashMap.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                hashMap.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return null;
            }
        });
        string2 = (String)hashMap.get("trustStore");
        if (!"NONE".equals(string2)) {
            if (string2 != null) {
                file = new File(string2);
                fileInputStream = TrustManagerFactoryImpl.getFileInputStream(file);
            } else {
                object = (String)hashMap.get("javaHome");
                file = new File((String)object + string3 + "lib" + string3 + "security" + string3 + "jssecacerts");
                fileInputStream = TrustManagerFactoryImpl.getFileInputStream(file);
                if (fileInputStream == null) {
                    file = new File((String)object + string3 + "lib" + string3 + "security" + string3 + "cacerts");
                    fileInputStream = TrustManagerFactoryImpl.getFileInputStream(file);
                }
            }
            string2 = fileInputStream != null ? file.getPath() : "No File Available, using empty keystore.";
        }
        String string4 = (String)hashMap.get("trustStoreType");
        String string5 = (String)hashMap.get("trustStoreProvider");
        if (debug != null && Debug.isOn(string)) {
            System.out.println("trustStore is: " + string2);
            System.out.println("trustStore type is : " + string4);
            System.out.println("trustStore provider is : " + string5);
        }
        if (string4.length() != 0) {
            if (debug != null && Debug.isOn(string)) {
                System.out.println("init truststore");
            }
            keyStore = string5.length() == 0 ? KeyStore.getInstance(string4) : KeyStore.getInstance(string4, string5);
            object = null;
            String string6 = (String)hashMap.get("trustStorePasswd");
            if (string6.length() != 0) {
                object = string6.toCharArray();
            }
            keyStore.load(fileInputStream, (char[])object);
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = false;
                }
            }
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        return keyStore;
    }

    public static final class PKIXFactory
    extends TrustManagerFactoryImpl {
        X509TrustManager getInstance(KeyStore keyStore) throws KeyStoreException {
            return new X509TrustManagerImpl("PKIX", keyStore);
        }

        X509TrustManager getInstance(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            if (!(managerFactoryParameters instanceof CertPathTrustManagerParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be CertPathTrustManagerParameters");
            }
            CertPathParameters certPathParameters = ((CertPathTrustManagerParameters)managerFactoryParameters).getParameters();
            if (!(certPathParameters instanceof PKIXBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Encapsulated parameters must be PKIXBuilderParameters");
            }
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
            return new X509TrustManagerImpl("PKIX", pKIXBuilderParameters);
        }
    }

    public static final class SimpleFactory
    extends TrustManagerFactoryImpl {
        X509TrustManager getInstance(KeyStore keyStore) throws KeyStoreException {
            return new X509TrustManagerImpl("Simple", keyStore);
        }

        X509TrustManager getInstance(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("SunX509 TrustManagerFactory does not use ManagerFactoryParameters");
        }
    }
}

