/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.util;

import ghostfucker.utils.sun.security.util.BitArray;
import ghostfucker.utils.sun.security.util.ByteArrayLexOrder;
import ghostfucker.utils.sun.security.util.ByteArrayTagOrder;
import ghostfucker.utils.sun.security.util.DerEncoder;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.util.ObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream(int n) {
        super(n);
    }

    public DerOutputStream() {
    }

    public void write(byte by, byte[] byArray) throws IOException {
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void writeImplicit(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.write(derOutputStream.buf, 1, derOutputStream.count - 1);
    }

    public void putDerValue(DerValue derValue) throws IOException {
        derValue.encode(this);
    }

    public void putBoolean(boolean bl) throws IOException {
        this.write(1);
        this.putLength(1);
        if (bl) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putEnumerated(int n) throws IOException {
        this.write(10);
        this.putIntegerContents(n);
    }

    public void putInteger(BigInteger bigInteger) throws IOException {
        this.write(2);
        byte[] byArray = bigInteger.toByteArray();
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void putInteger(Integer n) throws IOException {
        this.putInteger((int)n);
    }

    public void putInteger(int n) throws IOException {
        this.write(2);
        this.putIntegerContents(n);
    }

    private void putIntegerContents(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[4];
        int n3 = 0;
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n & 0xFF00) >>> 8);
        byArray[1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[0] = (byte)((n & 0xFF000000) >>> 24);
        if (byArray[0] == 255) {
            for (n2 = 0; n2 < 3 && byArray[n2] == 255 && (byArray[n2 + 1] & 0x80) == 128; ++n2) {
                ++n3;
            }
        } else if (byArray[0] == 0) {
            for (n2 = 0; n2 < 3 && byArray[n2] == 0 && (byArray[n2 + 1] & 0x80) == 0; ++n2) {
                ++n3;
            }
        }
        this.putLength(4 - n3);
        for (n2 = n3; n2 < 4; ++n2) {
            this.write(byArray[n2]);
        }
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    public void putUnalignedBitString(BitArray bitArray) throws IOException {
        byte[] byArray = bitArray.toByteArray();
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(byArray.length * 8 - bitArray.length());
        this.write(byArray);
    }

    public void putTruncatedUnalignedBitString(BitArray bitArray) throws IOException {
        this.putUnalignedBitString(bitArray.truncate());
    }

    public void putOctetString(byte[] byArray) throws IOException {
        this.write((byte)4, byArray);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectIdentifier) throws IOException {
        objectIdentifier.encode(this);
    }

    public void putSequence(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derValueArray.length; ++i) {
            derValueArray[i].encode(derOutputStream);
        }
        this.write((byte)48, derOutputStream);
    }

    public void putSet(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derValueArray.length; ++i) {
            derValueArray[i].encode(derOutputStream);
        }
        this.write((byte)49, derOutputStream);
    }

    public void putOrderedSetOf(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, lexOrder);
    }

    public void putOrderedSet(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, tagOrder);
    }

    private void putOrderedSet(byte by, DerEncoder[] derEncoderArray, Comparator<byte[]> comparator) throws IOException {
        DerOutputStream[] derOutputStreamArray = new DerOutputStream[derEncoderArray.length];
        for (int i = 0; i < derEncoderArray.length; ++i) {
            derOutputStreamArray[i] = new DerOutputStream();
            derEncoderArray[i].derEncode(derOutputStreamArray[i]);
        }
        byte[][] byArrayArray = new byte[derOutputStreamArray.length][];
        for (int i = 0; i < derOutputStreamArray.length; ++i) {
            byArrayArray[i] = derOutputStreamArray[i].toByteArray();
        }
        Arrays.sort(byArrayArray, comparator);
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derOutputStreamArray.length; ++i) {
            derOutputStream.write(byArrayArray[i]);
        }
        this.write(by, derOutputStream);
    }

    public void putUTF8String(String string) throws IOException {
        this.writeString(string, (byte)12, "UTF8");
    }

    public void putPrintableString(String string) throws IOException {
        this.writeString(string, (byte)19, "ASCII");
    }

    public void putT61String(String string) throws IOException {
        this.writeString(string, (byte)20, "ISO-8859-1");
    }

    public void putIA5String(String string) throws IOException {
        this.writeString(string, (byte)22, "ASCII");
    }

    public void putBMPString(String string) throws IOException {
        this.writeString(string, (byte)30, "UnicodeBigUnmarked");
    }

    public void putGeneralString(String string) throws IOException {
        this.writeString(string, (byte)27, "ASCII");
    }

    private void writeString(String string, byte by, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putUTCTime(Date date) throws IOException {
        this.putTime(date, (byte)23);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        this.putTime(date, (byte)24);
    }

    private void putTime(Date date, byte by) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = null;
        if (by == 23) {
            string = "yyMMddHHmmss'Z'";
        } else {
            by = (byte)24;
            string = "yyyyMMddHHmmss'Z'";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes("ISO-8859-1");
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putLength(int n) throws IOException {
        if (n < 128) {
            this.write((byte)n);
        } else if (n < 256) {
            this.write(-127);
            this.write((byte)n);
        } else if (n < 65536) {
            this.write(-126);
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else if (n < 0x1000000) {
            this.write(-125);
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else {
            this.write(-124);
            this.write((byte)(n >> 24));
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        }
    }

    public void putTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        this.write(by3);
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }
}

