/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.validator;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStores {
    private KeyStores() {
    }

    public static Set<X509Certificate> getTrustedCerts(KeyStore keyStore) {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                String string = enumeration.nextElement();
                if (keyStore.isCertificateEntry(string)) {
                    certificateArray = keyStore.getCertificate(string);
                    if (!(certificateArray instanceof X509Certificate)) continue;
                    hashSet.add((X509Certificate)certificateArray);
                    continue;
                }
                if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
                hashSet.add((X509Certificate)certificateArray[0]);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return hashSet;
    }
}

