/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.x509;

import ghostfucker.utils.sun.security.util.Debug;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    private static final long serialVersionUID = 3437177836797504046L;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public AlgIdDSA() {
    }

    AlgIdDSA(DerValue derValue) throws IOException {
        super(derValue.getOID());
    }

    public AlgIdDSA(byte[] byArray) throws IOException {
        super(new DerValue(byArray).getOID());
    }

    public AlgIdDSA(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this(new BigInteger(1, byArray), new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public AlgIdDSA(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(DSA_oid);
        if (bigInteger != null || bigInteger2 != null || bigInteger3 != null) {
            if (bigInteger == null || bigInteger2 == null || bigInteger3 == null) {
                throw new ProviderException("Invalid parameters for DSS/DSA Algorithm ID");
            }
            try {
                this.p = bigInteger;
                this.q = bigInteger2;
                this.g = bigInteger3;
                this.initializeParams();
            }
            catch (IOException iOException) {
                throw new ProviderException("Construct DSS/DSA Algorithm ID");
            }
        }
    }

    public String getName() {
        return "DSA";
    }

    private void initializeParams() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.p);
        derOutputStream.putInteger(this.q);
        derOutputStream.putInteger(this.g);
        this.params = new DerValue(48, derOutputStream.toByteArray());
    }

    protected void decodeParams() throws IOException {
        if (this.params == null) {
            throw new IOException("DSA alg params are null");
        }
        if (this.params.tag != 48) {
            throw new IOException("DSA alg parsing error");
        }
        this.params.data.reset();
        this.p = this.params.data.getBigInteger();
        this.q = this.params.data.getBigInteger();
        this.g = this.params.data.getBigInteger();
        if (this.params.data.available() != 0) {
            throw new IOException("AlgIdDSA params, extra=" + this.params.data.available());
        }
    }

    public String toString() {
        return this.paramsToString();
    }

    protected String paramsToString() {
        if (this.params == null) {
            return " null\n";
        }
        return "\n    p:\n" + Debug.toHexString(this.p) + "\n    q:\n" + Debug.toHexString(this.q) + "\n    g:\n" + Debug.toHexString(this.g) + "\n";
    }
}

