/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.x509;

import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.x509.CertificatePolicyId;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificatePolicySet {
    private final Vector<CertificatePolicyId> ids;

    public CertificatePolicySet(Vector<CertificatePolicyId> vector) {
        this.ids = vector;
    }

    public CertificatePolicySet(DerInputStream derInputStream) throws IOException {
        this.ids = new Vector();
        DerValue[] derValueArray = derInputStream.getSequence(5);
        for (int i = 0; i < derValueArray.length; ++i) {
            CertificatePolicyId certificatePolicyId = new CertificatePolicyId(derValueArray[i]);
            this.ids.addElement(certificatePolicyId);
        }
    }

    public String toString() {
        String string = "CertificatePolicySet:[\n" + this.ids.toString() + "]\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.ids.size(); ++i) {
            this.ids.elementAt(i).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public List<CertificatePolicyId> getCertPolicyIds() {
        return Collections.unmodifiableList(this.ids);
    }
}

