/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.x509;

import ghostfucker.utils.sun.security.util.BitArray;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.x509.AttributeNameEnumeration;
import ghostfucker.utils.sun.security.x509.CertAttrSet;
import ghostfucker.utils.sun.security.x509.Extension;
import ghostfucker.utils.sun.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.KeyUsage";
    public static final String NAME = "KeyUsage";
    public static final String DIGITAL_SIGNATURE = "digital_signature";
    public static final String NON_REPUDIATION = "non_repudiation";
    public static final String KEY_ENCIPHERMENT = "key_encipherment";
    public static final String DATA_ENCIPHERMENT = "data_encipherment";
    public static final String KEY_AGREEMENT = "key_agreement";
    public static final String KEY_CERTSIGN = "key_certsign";
    public static final String CRL_SIGN = "crl_sign";
    public static final String ENCIPHER_ONLY = "encipher_only";
    public static final String DECIPHER_ONLY = "decipher_only";
    private boolean[] bitString;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putTruncatedUnalignedBitString(new BitArray(this.bitString));
        this.extensionValue = derOutputStream.toByteArray();
    }

    private boolean isSet(int n) {
        return this.bitString[n];
    }

    private void set(int n, boolean bl) {
        if (n >= this.bitString.length) {
            boolean[] blArray = new boolean[n + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n] = bl;
    }

    public KeyUsageExtension(byte[] byArray) throws IOException {
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
    }

    public KeyUsageExtension(boolean[] blArray) throws IOException {
        this.bitString = blArray;
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
    }

    public KeyUsageExtension(BitArray bitArray) throws IOException {
        this.bitString = bitArray.toBooleanArray();
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.encodeThis();
    }

    public KeyUsageExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = bl;
        byte[] byArray = (byte[])object;
        this.extensionValue = byArray[0] == 4 ? new DerValue(byArray).getOctetString() : byArray;
        DerValue derValue = new DerValue(this.extensionValue);
        this.bitString = derValue.getUnalignedBitString().toBooleanArray();
    }

    public KeyUsageExtension() {
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = true;
        this.bitString = new boolean[0];
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl = (Boolean)object;
        if (string.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            this.set(0, bl);
        } else if (string.equalsIgnoreCase(NON_REPUDIATION)) {
            this.set(1, bl);
        } else if (string.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            this.set(2, bl);
        } else if (string.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            this.set(3, bl);
        } else if (string.equalsIgnoreCase(KEY_AGREEMENT)) {
            this.set(4, bl);
        } else if (string.equalsIgnoreCase(KEY_CERTSIGN)) {
            this.set(5, bl);
        } else if (string.equalsIgnoreCase(CRL_SIGN)) {
            this.set(6, bl);
        } else if (string.equalsIgnoreCase(ENCIPHER_ONLY)) {
            this.set(7, bl);
        } else if (string.equalsIgnoreCase(DECIPHER_ONLY)) {
            this.set(8, bl);
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            return this.isSet(0);
        }
        if (string.equalsIgnoreCase(NON_REPUDIATION)) {
            return this.isSet(1);
        }
        if (string.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            return this.isSet(2);
        }
        if (string.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            return this.isSet(3);
        }
        if (string.equalsIgnoreCase(KEY_AGREEMENT)) {
            return this.isSet(4);
        }
        if (string.equalsIgnoreCase(KEY_CERTSIGN)) {
            return this.isSet(5);
        }
        if (string.equalsIgnoreCase(CRL_SIGN)) {
            return this.isSet(6);
        }
        if (string.equalsIgnoreCase(ENCIPHER_ONLY)) {
            return this.isSet(7);
        }
        if (string.equalsIgnoreCase(DECIPHER_ONLY)) {
            return this.isSet(8);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(DIGITAL_SIGNATURE)) {
            this.set(0, false);
        } else if (string.equalsIgnoreCase(NON_REPUDIATION)) {
            this.set(1, false);
        } else if (string.equalsIgnoreCase(KEY_ENCIPHERMENT)) {
            this.set(2, false);
        } else if (string.equalsIgnoreCase(DATA_ENCIPHERMENT)) {
            this.set(3, false);
        } else if (string.equalsIgnoreCase(KEY_AGREEMENT)) {
            this.set(4, false);
        } else if (string.equalsIgnoreCase(KEY_CERTSIGN)) {
            this.set(5, false);
        } else if (string.equalsIgnoreCase(CRL_SIGN)) {
            this.set(6, false);
        } else if (string.equalsIgnoreCase(ENCIPHER_ONLY)) {
            this.set(7, false);
        } else if (string.equalsIgnoreCase(DECIPHER_ONLY)) {
            this.set(8, false);
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:KeyUsage.");
        }
        this.encodeThis();
    }

    @Override
    public String toString() {
        String string = super.toString() + "KeyUsage [\n";
        try {
            if (this.isSet(0)) {
                string = string + "  DigitalSignature\n";
            }
            if (this.isSet(1)) {
                string = string + "  Non_repudiation\n";
            }
            if (this.isSet(2)) {
                string = string + "  Key_Encipherment\n";
            }
            if (this.isSet(3)) {
                string = string + "  Data_Encipherment\n";
            }
            if (this.isSet(4)) {
                string = string + "  Key_Agreement\n";
            }
            if (this.isSet(5)) {
                string = string + "  Key_CertSign\n";
            }
            if (this.isSet(6)) {
                string = string + "  Crl_Sign\n";
            }
            if (this.isSet(7)) {
                string = string + "  Encipher_Only\n";
            }
            if (this.isSet(8)) {
                string = string + "  Decipher_Only\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.KeyUsage_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DIGITAL_SIGNATURE);
        attributeNameEnumeration.addElement(NON_REPUDIATION);
        attributeNameEnumeration.addElement(KEY_ENCIPHERMENT);
        attributeNameEnumeration.addElement(DATA_ENCIPHERMENT);
        attributeNameEnumeration.addElement(KEY_AGREEMENT);
        attributeNameEnumeration.addElement(KEY_CERTSIGN);
        attributeNameEnumeration.addElement(CRL_SIGN);
        attributeNameEnumeration.addElement(ENCIPHER_ONLY);
        attributeNameEnumeration.addElement(DECIPHER_ONLY);
        return attributeNameEnumeration.elements();
    }

    public boolean[] getBits() {
        return (boolean[])this.bitString.clone();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

