/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.x509;

import ghostfucker.utils.sun.security.util.BitArray;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.util.ObjectIdentifier;
import ghostfucker.utils.sun.security.x509.CertAttrSet;
import ghostfucker.utils.sun.security.x509.Extension;
import ghostfucker.utils.sun.security.x509.KeyUsageExtension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetscapeCertTypeExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.NetscapeCertType";
    public static final String NAME = "NetscapeCertType";
    public static final String SSL_CLIENT = "ssl_client";
    public static final String SSL_SERVER = "ssl_server";
    public static final String S_MIME = "s_mime";
    public static final String OBJECT_SIGNING = "object_signing";
    public static final String SSL_CA = "ssl_ca";
    public static final String S_MIME_CA = "s_mime_ca";
    public static final String OBJECT_SIGNING_CA = "object_signing_ca";
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    public static ObjectIdentifier NetscapeCertType_Id;
    private boolean[] bitString;
    private static MapEntry[] mMapData;
    private static final Vector<String> mAttributeNames;

    private static int getPosition(String string) throws IOException {
        for (int i = 0; i < mMapData.length; ++i) {
            if (!string.equalsIgnoreCase(NetscapeCertTypeExtension.mMapData[i].mName)) continue;
            return NetscapeCertTypeExtension.mMapData[i].mPosition;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by CertAttrSet:NetscapeCertType.");
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putTruncatedUnalignedBitString(new BitArray(this.bitString));
        this.extensionValue = derOutputStream.toByteArray();
    }

    private boolean isSet(int n) {
        return this.bitString[n];
    }

    private void set(int n, boolean bl) {
        if (n >= this.bitString.length) {
            boolean[] blArray = new boolean[n + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n] = bl;
    }

    public NetscapeCertTypeExtension(byte[] byArray) throws IOException {
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NetscapeCertTypeExtension(boolean[] blArray) throws IOException {
        this.bitString = blArray;
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NetscapeCertTypeExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = NetscapeCertType_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        this.bitString = derValue.getUnalignedBitString().toBooleanArray();
    }

    public NetscapeCertTypeExtension() {
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = new boolean[0];
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl = (Boolean)object;
        this.set(NetscapeCertTypeExtension.getPosition(string), bl);
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        return this.isSet(NetscapeCertTypeExtension.getPosition(string));
    }

    @Override
    public void delete(String string) throws IOException {
        this.set(NetscapeCertTypeExtension.getPosition(string), false);
        this.encodeThis();
    }

    @Override
    public String toString() {
        String string = super.toString() + "NetscapeCertType [\n";
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT))) {
                string = string + "   SSL client\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                string = string + "   SSL server\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME))) {
                string = string + "   S/MIME\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                string = string + "   Object Signing\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA))) {
                string = string + "   SSL CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA))) {
                string = string + "   S/MIME CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                string = string + "   Object Signing CA";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = NetscapeCertType_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public Enumeration<String> getElements() {
        return mAttributeNames.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean[] getKeyUsageMappedBits() {
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
        Boolean bl = Boolean.TRUE;
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                keyUsageExtension.set("digital_signature", bl);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                keyUsageExtension.set("key_encipherment", bl);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                keyUsageExtension.set("key_certsign", bl);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keyUsageExtension.getBits();
    }

    static {
        try {
            NetscapeCertType_Id = new ObjectIdentifier(CertType_data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        mMapData = new MapEntry[]{new MapEntry(SSL_CLIENT, 0), new MapEntry(SSL_SERVER, 1), new MapEntry(S_MIME, 2), new MapEntry(OBJECT_SIGNING, 3), new MapEntry(SSL_CA, 5), new MapEntry(S_MIME_CA, 6), new MapEntry(OBJECT_SIGNING_CA, 7)};
        mAttributeNames = new Vector();
        for (MapEntry mapEntry : mMapData) {
            mAttributeNames.add(mapEntry.mName);
        }
    }

    private static class MapEntry {
        String mName;
        int mPosition;

        MapEntry(String string, int n) {
            this.mName = string;
            this.mPosition = n;
        }
    }
}

