/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.x509;

import ghostfucker.utils.sun.security.util.BitArray;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.x509.AttributeNameEnumeration;
import java.io.IOException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonFlags {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFILIATION_CHANGED = "affiliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATE_HOLD = "certificate_hold";
    public static final String PRIVILEGE_WITHDRAWN = "privilege_withdrawn";
    public static final String AA_COMPROMISE = "aa_compromise";
    private static final String[] NAMES = new String[]{"unused", "key_compromise", "ca_compromise", "affiliation_changed", "superseded", "cessation_of_operation", "certificate_hold", "privilege_withdrawn", "aa_compromise"};
    private boolean[] bitString;

    private static int name2Index(String string) throws IOException {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    private boolean isSet(int n) {
        return this.bitString[n];
    }

    private void set(int n, boolean bl) {
        if (n >= this.bitString.length) {
            boolean[] blArray = new boolean[n + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n] = bl;
    }

    public ReasonFlags(byte[] byArray) {
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
    }

    public ReasonFlags(boolean[] blArray) {
        this.bitString = blArray;
    }

    public ReasonFlags(BitArray bitArray) {
        this.bitString = bitArray.toBooleanArray();
    }

    public ReasonFlags(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
    }

    public ReasonFlags(DerValue derValue) throws IOException {
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
    }

    public boolean[] getFlags() {
        return this.bitString;
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl = (Boolean)object;
        this.set(ReasonFlags.name2Index(string), bl);
    }

    public Object get(String string) throws IOException {
        return this.isSet(ReasonFlags.name2Index(string));
    }

    public void delete(String string) throws IOException {
        this.set(string, Boolean.FALSE);
    }

    public String toString() {
        String string = "Reason Flags [\n";
        try {
            if (this.isSet(0)) {
                string = string + "  Unused\n";
            }
            if (this.isSet(1)) {
                string = string + "  Key Compromise\n";
            }
            if (this.isSet(2)) {
                string = string + "  CA Compromise\n";
            }
            if (this.isSet(3)) {
                string = string + "  Affiliation_Changed\n";
            }
            if (this.isSet(4)) {
                string = string + "  Superseded\n";
            }
            if (this.isSet(5)) {
                string = string + "  Cessation Of Operation\n";
            }
            if (this.isSet(6)) {
                string = string + "  Certificate Hold\n";
            }
            if (this.isSet(7)) {
                string = string + "  Privilege Withdrawn\n";
            }
            if (this.isSet(8)) {
                string = string + "  AA Compromise\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putTruncatedUnalignedBitString(new BitArray(this.bitString));
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        for (int i = 0; i < NAMES.length; ++i) {
            attributeNameEnumeration.addElement(NAMES[i]);
        }
        return attributeNameEnumeration.elements();
    }
}

