/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.x509;

import ghostfucker.utils.sun.security.util.Debug;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class SerialNumber {
    private BigInteger serialNum;

    private void construct(DerValue derValue) throws IOException {
        this.serialNum = derValue.getBigInteger();
        if (derValue.data.available() != 0) {
            throw new IOException("Excess SerialNumber data");
        }
    }

    public SerialNumber(BigInteger bigInteger) {
        this.serialNum = bigInteger;
    }

    public SerialNumber(int n) {
        this.serialNum = BigInteger.valueOf(n);
    }

    public SerialNumber(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
    }

    public SerialNumber(DerValue derValue) throws IOException {
        this.construct(derValue);
    }

    public SerialNumber(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.construct(derValue);
    }

    public String toString() {
        return "SerialNumber: [" + Debug.toHexString(this.serialNum) + "]";
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putInteger(this.serialNum);
    }

    public BigInteger getNumber() {
        return this.serialNum;
    }
}

