/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.x509;

import ghostfucker.utils.sun.security.x509.AlgorithmId;
import ghostfucker.utils.sun.security.x509.X500Name;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Signer;

public final class X500Signer
extends Signer {
    private static final long serialVersionUID = -8609982645394364834L;
    private Signature sig;
    private X500Name agent;
    private AlgorithmId algid;

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.sig.update(byArray, n, n2);
    }

    public byte[] sign() throws SignatureException {
        return this.sig.sign();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public X500Name getSigner() {
        return this.agent;
    }

    public X500Signer(Signature signature, X500Name x500Name) {
        if (signature == null || x500Name == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = signature;
        this.agent = x500Name;
        try {
            this.algid = AlgorithmId.getAlgorithmId(signature.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("internal error! " + noSuchAlgorithmException.getMessage());
        }
    }
}

